/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.bendable_cuboids.impl;

import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Plane {
    public final Vector3f normal;
    private final float normDistance;

    public Plane(Vector3f normal, Vector3f position) {
        this.normal = normal;
        this.normal.normalize();
        this.normDistance = -this.normal.dot((Vector3fc)position);
    }

    public Plane(Vector3f normal, float normDistance) {
        this.normal = normal;
        this.normDistance = normDistance;
    }

    public Plane scaled(float scalar) {
        return new Plane(new Vector3f((Vector3fc)this.normal), this.normDistance * scalar);
    }

    public float distanceTo(Vector3f pos) {
        return this.normal.dot((Vector3fc)pos) + this.normDistance;
    }

    public float distanceTo(Plane otherPlane) {
        Vector3f tmp = new Vector3f((Vector3fc)this.normal);
        tmp.cross((Vector3fc)otherPlane.normal);
        if ((double)tmp.dot((Vector3fc)tmp) < 0.01) {
            return this.normDistance + this.normal.dot((Vector3fc)otherPlane.normal) * otherPlane.normDistance;
        }
        return 0.0f;
    }
}

