package com.zigythebird.bendable_cuboids.mixin;

import com.google.common.collect.ImmutableList;
import com.zigythebird.bendable_cuboids.api.ICubeDefinition;
import com.zigythebird.bendable_cuboids.api.IPartDefinition;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2350;
import net.minecraft.class_5603;
import net.minecraft.class_5604;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Mixin(class_5610.class)
public abstract class PartDefinitionMixin implements IPartDefinition {
    @Shadow @Final private Map<String, class_5610> children;

    @Shadow @Final private List<class_5604> cubes;

    @Shadow @Final private class_5603 partPose;

    @Shadow public abstract class_630 bake(int texWidth, int texHeight);

    @Override
    public class_630 bakeBendablePart(int texWidth, int texHeight, Map<String, Pair<class_2350, Integer>> cuboidDataMap, Set<String> noBends, String name) {
        if (noBends.contains(name)) return this.bake(texWidth, texHeight);
        Pair<class_2350, Integer> cuboidData = cuboidDataMap.getOrDefault(name, Pair.of(class_2350.field_11036, -1));
        Object2ObjectArrayMap<String, class_630> object2objectarraymap = this.children.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, (partDefinitionMap) -> ((IPartDefinition)partDefinitionMap.getValue()).bakeBendablePart(texWidth, texHeight, cuboidDataMap, noBends, partDefinitionMap.getKey()), (modelPart, modelPart1) -> modelPart, Object2ObjectArrayMap::new));
        List<class_630.class_628> list = this.cubes.stream().map((definition) -> ((ICubeDefinition)definition).bakeBendableCuboid(texWidth, texHeight, cuboidData.left(), cuboidData.right())).collect(ImmutableList.toImmutableList());
        class_630 modelpart = new class_630(list, object2objectarraymap);
        modelpart.method_41918(this.partPose);
        modelpart.method_32085(this.partPose);
        return modelpart;
    }
}
