package com.zigythebird.bendable_cuboids.mixin.playeranim;

import com.zigythebird.bendable_cuboids.api.IMutableModel;
import com.zigythebird.bendable_cuboids.impl.compatibility.PlayerBendHelper;
import com.zigythebird.playeranim.accessors.IAvatarAnimationState;
import com.zigythebird.playeranim.animation.AvatarAnimManager;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import net.minecraft.class_10055;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_591.class, priority = 2002)
public abstract class PlayerModelMixin_playerAnim extends class_572<class_10055> implements IMutableModel {
    @Shadow
    @Final
    public class_630 jacket;
    @Shadow
    @Final
    public class_630 rightSleeve;
    @Shadow
    @Final
    public class_630 leftSleeve;
    @Shadow
    @Final
    public class_630 rightPants;
    @Shadow
    @Final
    public class_630 leftPants;

    @Unique
    private AvatarAnimManager bc$animation = null;

    /**
     * Do not annotate with {@link @org.spongepowered.asm.mixin.Unique}: it breaks the bends.
     */
    private final PlayerAnimBone pal$torso = new PlayerAnimBone("torso");
    private final PlayerAnimBone pal$rightArm = new PlayerAnimBone("right_arm");
    private final PlayerAnimBone pal$leftArm = new PlayerAnimBone("left_arm");
    private final PlayerAnimBone pal$rightLeg = new PlayerAnimBone("right_leg");
    private final PlayerAnimBone pal$leftLeg = new PlayerAnimBone("left_leg");

    public PlayerModelMixin_playerAnim(class_630 root) {
        super(root);
    }

    @Inject(method = "setupAnim(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;)V", at = @At(value = "RETURN"))
    private void setupPlayerAnimation(class_10055 playerRenderState, CallbackInfo ci) {
        AvatarAnimManager manager = playerRenderState instanceof IAvatarAnimationState state ? state.playerAnimLib$getAnimManager() : null;
        if (manager != null && manager.isActive()) {
            this.bc$animation = manager;

            PlayerBendHelper.bend(this.field_3391, pal$torso.getBend());
            PlayerBendHelper.bend(this.field_3401, pal$rightArm.getBend());
            PlayerBendHelper.bend(this.field_27433, pal$leftArm.getBend());
            PlayerBendHelper.bend(this.field_3392, pal$rightLeg.getBend());
            PlayerBendHelper.bend(this.field_3397, pal$leftLeg.getBend());

            PlayerBendHelper.bend(this.jacket, pal$torso.getBend());
            PlayerBendHelper.bend(this.rightSleeve, pal$rightArm.getBend());
            PlayerBendHelper.bend(this.leftSleeve, pal$leftArm.getBend());
            PlayerBendHelper.bend(this.rightPants, pal$rightLeg.getBend());
            PlayerBendHelper.bend(this.leftPants, pal$leftLeg.getBend());
        } else {
            PlayerBendHelper.resetBend(this.field_3391);
            PlayerBendHelper.resetBend(this.field_27433);
            PlayerBendHelper.resetBend(this.field_3401);
            PlayerBendHelper.resetBend(this.field_3397);
            PlayerBendHelper.resetBend(this.field_3392);

            PlayerBendHelper.resetBend(this.jacket);
            PlayerBendHelper.resetBend(this.leftSleeve);
            PlayerBendHelper.resetBend(this.rightSleeve);
            PlayerBendHelper.resetBend(this.leftPants);
            PlayerBendHelper.resetBend(this.rightPants);

            this.bc$animation = null;
        }
    }

    @Override
    public @Nullable AvatarAnimManager bc$getAnimation() {
        return this.bc$animation;
    }
}
