/*
    Presented by TRTIMC Project by Xiaotang27 (C)2025-present.
*/

importPackage(java.awt);
importPackage(java.awt.geom);

include(Resources.id("mtrsteamloco:scripts/display_helper.js"));

let slotCfg = {
  "version": 1,
  "texSize": [1800, 1000],
  "slots": [
    {
      "name": "lcd_door_left",
      "texArea": [0, 0, 700, 200],
      "pos": [
        [[-0.57, 1.89, 8.9], [-0.57, 1.751, 8.9], [0.01, 1.751, 8.9], [0.01, 1.89, 8.9]]
      ],
      "offsets": [[0, 0, 0]]
    },

  ]
};
let slotCfg1 = {
  "version": 1,
  "texSize": [1800, 1000],
  "slots": [
    {
      "name": "lcd_door_right",
      "texArea": [0, 0, 700, 200],
      "pos": [
        [[0.57, 1.89, -8.9], [0.57, 1.751, -8.9], [-0.01, 1.751, -8.9], [-0.01, 1.89, -8.9]]
      ],
      "offsets": [[0, 0, 0]]
    }
  ]
};

var dhBase = new DisplayHelper(slotCfg);
var dhZBase = new DisplayHelper(slotCfg1);


// let screenSize = [1920, 400];

var WIDTH;
var HEIGHT;
var DEST;

const fontCJK = Resources.getSystemFont("Noto Sans");
const fontENG = Resources.getSystemFont("Noto Sans");

/** 
@param {Train} train
**/

function create(ctx, state, train) {
  let g;
  let f;
  state.pisRateLimit = new RateLimit(3);
  state.dh = dhBase.create();
  state.dhZ = dhZBase.create();

  g = state.dh.graphicsFor("lcd_door_left");
  // ctx.drawCarModel(state.dh.model, 0, null);
  // drawLED(570, 1000, g, train);

  f = state.dhZ.graphicsFor("lcd_door_right");
  // ctx.drawCarModel(state.dhZ.model, train.trainCars() - 1, null);
  // drawLED(570, 1000, f, train);

  print("DKZ9 Display has been successfully loaded.");
}
/** 
@param {Train} train
**/


function render(ctx, state, train) {
  g = state.dh.graphicsFor("lcd_door_left");
  ctx.drawCarModel(state.dh.model, 0, null);
  drawLED(570, 1000, g, train);

  f = state.dhZ.graphicsFor("lcd_door_right");
  ctx.drawCarModel(state.dhZ.model, train.trainCars() - 1, null)
  drawLED(570, 1000, f, train);

  state.dh.upload();
  state.dhZ.upload();
}

/** 
@param {Train} train
**/

function dispose(ctx, state, train) {
  state.dh.close();
  state.dhZ.close();
}

/** 
@param {Train} train
**/

function drawLED(width, height, g, train) {
  let WIDTH = width;
  let HEIGHT = height;

  let STNs = train.getThisRoutePlatforms();
  print(STNs);
  let DEST1 = STNs.get(STNs.size() - 1);
  let DEST = DEST1.destinationName;

  let routeInfo = {
    destination: DEST,
  };

  let DESTCJK = TextUtil.getCjkParts(DEST); // 中文终点站
  let DESTENG = TextUtil.getNonCjkParts(DEST); // 英文终点站
  let fontcjk = fontCJK.deriveFont(110.0);
  let fonteng = fontENG.deriveFont(60.0);

  drawXCJK = (WIDTH / 2) - (g.getFontMetrics(fontcjk).stringWidth(DESTCJK)) / 2;
  drawXENG = (WIDTH / 2) - (g.getFontMetrics(fonteng).stringWidth(DESTENG)) / 2;

  g.setColor(Color.BLACK); //黑屏
  g.fillRect(0, 0, WIDTH, HEIGHT);

  g.setColor(Color.RED) // 绘制中文站名
  g.setFont(fontcjk);
  g.drawString(DESTCJK, drawXCJK, HEIGHT * 0.12);

  g.setFont(fonteng); // 绘制英文站名
  g.drawString(DESTENG, drawXENG, HEIGHT * 0.18);
}

function getTransferInfo(train, stnIndex) {
  let platList = train.getAllPlatforms();
  let transfers = new Array();
  if (platList[stnIndex] != undefined) {
    let stnRoutes = MTRClientData.DATA_CACHE.stationIdToRoutes.get(
      new java.lang.Long(platList[stnIndex].station.id)
    );
    for (var it = stnIndex.values().iterator(), i = 0; it.hasNext(); i++) {
      var routesHashMap = it.next();
      transfers.push([
        routename = routesHashMap.name,
      ]);
    }
    if (transfers[0] != undefined) {
      return transfers;
    } else {
      return null;
    }
  }
}

/*
function scrollingText(width, height, g, train) {
  let scrollSTNS = train.getThisRoutePlatforms();
  let scrollDEST1 = scrollSTNS.get(scrollSTNS.size() - 1);
  let scrollDEST = scrollDEST1.destinationName;

  let DEPOT = undefined
  let nextSTNIndex = train.getThisRoutePlatformsNextIndex();
  if (nextSTNIndex = scrollSTNS.size()) {
    return DEPOT = true
  };
  let nextSTN = scrollSTNS[nextSTNIndex].station.name

  let scrollDESTCJK = TextUtil.getCjkParts(scrollDEST); // 中文终点站
  let scrollDESTENG = TextUtil.getNonCjkParts(scrollDEST); // 英文终点站
  let nestSTNCjk = TextUtil.getCjkParts(nextSTN);
  let nestSTNEng = TextUtil.getNonCjkParts(nextSTN);
  let fontcjk = fontCJK.deriveFont(110.0);
  let fonteng = fontENG.deriveFont(110.0);

  let rolltextNormal = "本次列车终点站" + scrollDESTCJK + "。下一站：" + nestSTNCjk + "，next station:" + nestSTNEng + ".";
  let rolltextThisNormal = "本站：" + nestSTNCjk + nestSTNEng + "station.";
  let rolltextTransfer = "本次列车终点站" + scrollDESTCJK + "。下一站：" + nestSTNCjk + "，next station:" + nestSTNEng + ".";
  if (DEPOT == true) {
    let rolltextDepot = "本次列车退出服务，请全部下车。This train is out of service. All change please.";
  }


  MinecraftClient.displayMessage(rolltextNormal, false)
}
*/