/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.royal.block;

import dev.apexstudios.apexcore.lib.block.Dyeable;
import dev.apexstudios.fantasyfurniture.block.TableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class RoyalTableBlock
extends TableBlock {
    public static final VoxelShape SHAPE_TABLE_TOP = RoyalTableBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_TABLE_LEG = RoyalTableBlock.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)5.0);

    public RoyalTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(Dyeable.PROPERTY, (Comparable)Dyeable.DEFAULT_COLOR));
    }

    protected VoxelShape getLegShape() {
        return SHAPE_TABLE_LEG;
    }

    protected VoxelShape getTopShape() {
        return SHAPE_TABLE_TOP;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{Dyeable.PROPERTY});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placementBlockState = super.getStateForPlacement(context);
        if (placementBlockState == null) {
            return null;
        }
        DyeColor color = Dyeable.getColorForPlacement((BlockPlaceContext)context);
        return (BlockState)placementBlockState.setValue(Dyeable.PROPERTY, (Comparable)color);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return Dyeable.useItemOn((Level)level, (BlockPos)pos, (BlockState)blockState, (ItemStack)stack);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState, boolean includeData, Player player) {
        return Dyeable.getCloneStack((ItemLike)this, (BlockState)blockState, (Player)player, (boolean)includeData);
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState, boolean includeData) {
        return Dyeable.getCloneStack((ItemLike)this, (BlockState)blockState, null, (boolean)includeData);
    }
}

