/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.royal.block;

import dev.apexstudios.fantasyfurniture.block.WallLightBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class RoyalWallLightBlock
extends WallLightBlock {
    public static final VoxelShape SHAPE = RoyalWallLightBlock.box((double)4.75, (double)1.0, (double)11.75, (double)11.25, (double)13.0, (double)16.0);

    public RoyalWallLightBlock(BlockBehaviour.Properties properties) {
        super(ParticleTypes.FLAME, properties, SHAPE);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.7;
        double z = (double)pos.getZ() + 0.5;
        Direction facing = ((Direction)blockState.getValue((Property)FACING)).getOpposite();
        Direction attachFacing = facing.getClockWise();
        double offset = 0.4;
        double lightOffset = 0.15;
        double offsetX = lightOffset * (double)attachFacing.getStepX();
        double offsetZ = lightOffset * (double)attachFacing.getStepZ();
        this.addParticles(level, (x += offset * (double)facing.getStepX()) + offsetX, y, (z += offset * (double)facing.getStepZ()) + offsetZ);
        this.addParticles(level, x - offsetX, y, z - offsetZ);
    }

    private void addParticles(Level level, double x, double y, double z) {
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.flameParticle, x, y, z, 0.0, 0.0, 0.0);
    }
}

