/*
 * Decompiled with CFR 0.152.
 */
package net.thanachot.autoItemInActionbar.listener;

import net.thanachot.autoItemInActionbar.AutoItemInActionbar;
import net.thanachot.autoItemInActionbar.manager.CommonRefillHandler;
import net.thanachot.autoItemInActionbar.manager.RemainderProviderItemHandler;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final AutoItemInActionbar plugin;
    CommonRefillHandler commonRefillHandler = new CommonRefillHandler();
    RemainderProviderItemHandler remainderProviderItemHandler = new RemainderProviderItemHandler();

    public PlayerListener(AutoItemInActionbar plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.remainderProviderItemHandler.handle(player, ItemStack.of((Material)Material.BUCKET)), 1L);
    }

    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.remainderProviderItemHandler.handle(player, ItemStack.of((Material)event.getBucket())), 1L);
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        this.commonRefillHandler.handle(player, event.getItemInHand());
    }

    @EventHandler
    public void PlayerDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        this.commonRefillHandler.handle(player, event.getItemDrop().getItemStack());
    }

    @EventHandler
    public void onThrow(PlayerEggThrowEvent event) {
        Player player = event.getPlayer();
        this.commonRefillHandler.handle(player, event.getEgg().getItem());
    }

    @EventHandler
    public void onPlayerItemBreak(PlayerItemBreakEvent event) {
        Player player = event.getPlayer();
        this.commonRefillHandler.handle(player, event.getBrokenItem());
    }

    @EventHandler
    public void onPlayerPotionSplash(PotionSplashEvent event) {
        Player player = (Player)event.getPotion().getShooter();
        if (event.getPotion().getItem().getType() != Material.SPLASH_POTION) {
            return;
        }
        if (player != null) {
            this.commonRefillHandler.handle(player, event.getPotion().getItem());
        }
    }

    @EventHandler
    public void onLingeringPotionSplashEvent(LingeringPotionSplashEvent event) {
        Player player = (Player)event.getEntity().getShooter();
        if (event.getEntity().getItem().getType() != Material.LINGERING_POTION) {
            return;
        }
        if (player != null) {
            this.commonRefillHandler.handle(player, event.getEntity().getItem());
        }
    }

    @EventHandler
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        Material consumeItemType = event.getItem().getType();
        switch (consumeItemType) {
            case MILK_BUCKET: 
            case SUSPICIOUS_STEW: 
            case MUSHROOM_STEW: 
            case RABBIT_STEW: 
            case BEETROOT_SOUP: 
            case POTION: 
            case HONEY_BOTTLE: {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.remainderProviderItemHandler.handle(player, event.getItem()), 1L);
            }
        }
    }
}

