/*
 * Decompiled with CFR 0.152.
 */
package xyz.tantaihaha.autoItemInActionbar.core;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import xyz.tantaihaha.autoItemInActionbar.core.Refill;
import xyz.tantaihaha.autoItemInActionbar.utils.FindAndRemoveStack;
import xyz.tantaihaha.autoItemInActionbar.utils.SendRefillFeedback;

public class Item {
    private static Plugin plugin;
    private static final Set<UUID> processing;

    public Item(Plugin plugin) {
        Item.plugin = plugin;
    }

    public static void refillItem(Player player) {
        int maxStack;
        if (processing.contains(player.getUniqueId())) {
            return;
        }
        int slot = player.getInventory().getHeldItemSlot();
        ItemStack usedItem = player.getInventory().getItem(slot);
        Material usedType = usedItem != null && usedItem.getType() != Material.AIR ? usedItem.getType() : null;
        int n = maxStack = usedType != null ? usedType.getMaxStackSize() : 64;
        if (usedItem == null || Refill.isBucketType(usedType)) {
            return;
        }
        if (usedItem.getType().name().endsWith("_HELMET") || usedItem.getType().name().endsWith("_CHESTPLATE") || usedItem.getType().name().endsWith("_LEGGINGS") || usedItem.getType().name().endsWith("_BOOTS")) {
            return;
        }
        processing.add(player.getUniqueId());
        Bukkit.getServer().getScheduler().runTaskLater(plugin, () -> {
            try {
                ItemStack refill;
                ItemStack currentItem = player.getInventory().getItem(slot);
                if ((currentItem == null || currentItem.getType() == Material.AIR || currentItem.getAmount() == 0) && usedType != null && (refill = new FindAndRemoveStack(player, usedType, maxStack, slot).getRefillStack()) != null) {
                    player.getInventory().setItem(slot, refill);
                    new SendRefillFeedback(player);
                }
            }
            finally {
                processing.remove(player.getUniqueId());
            }
        }, 1L);
    }

    public static void refillOnDropItem(Player player, ItemStack dropped) {
        if (processing.contains(player.getUniqueId())) {
            return;
        }
        int slot = player.getInventory().getHeldItemSlot();
        ItemStack handItem = player.getInventory().getItem(slot);
        if (handItem == null || handItem.getType() == Material.AIR) {
            Material dropType = dropped.getType();
            int maxStack = dropType.getMaxStackSize();
            processing.add(player.getUniqueId());
            Bukkit.getServer().getScheduler().runTaskLater(plugin, () -> {
                try {
                    ItemStack refill = new FindAndRemoveStack(player, dropType, maxStack, slot).getRefillStack();
                    if (refill != null) {
                        player.getInventory().setItem(slot, refill);
                        new SendRefillFeedback(player);
                    }
                }
                finally {
                    processing.remove(player.getUniqueId());
                }
            }, 1L);
        }
    }

    static {
        processing = new HashSet<UUID>();
    }
}

