/*
 * Decompiled with CFR 0.152.
 */
package xyz.tantaihaha.autoItemInActionbar.core;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import xyz.tantaihaha.autoItemInActionbar.core.Bucket;
import xyz.tantaihaha.autoItemInActionbar.core.Item;
import xyz.tantaihaha.autoItemInActionbar.enums.RefillType;

public class Refill {
    public static void refill(Player player, RefillType type) {
        Material mat;
        if (type == RefillType.ON_DROP) {
            throw new IllegalArgumentException("RefillType.ON_DROP requires a droppedStack argument. Use refill(player, RefillType.ON_DROP, droppedStack)");
        }
        int slot = player.getInventory().getHeldItemSlot();
        ItemStack item = player.getInventory().getItem(slot);
        Material material = mat = item != null && item.getType() != Material.AIR ? item.getType() : null;
        if (mat == null) {
            return;
        }
        switch (type) {
            case ON_BUCKET: {
                Bucket.refillBucket(player);
                break;
            }
            default: {
                if (Refill.isBucketType(mat)) {
                    Bucket.refillBucket(player);
                    break;
                }
                Item.refillItem(player);
            }
        }
    }

    public static void refill(Player player, RefillType type, ItemStack droppedStack) {
        if (type == RefillType.ON_DROP) {
            Item.refillOnDropItem(player, droppedStack);
            return;
        }
        Refill.refill(player, type);
    }

    public static boolean isBucketType(Material type) {
        return type == Material.BUCKET || type == Material.WATER_BUCKET || type == Material.LAVA_BUCKET || type == Material.MILK_BUCKET || type == Material.POWDER_SNOW_BUCKET;
    }
}

