/*
 * Decompiled with CFR 0.152.
 */
package net.thanachot.autoItemInActionbar.listener;

import net.thanachot.autoItemInActionbar.AutoItemInActionbar;
import net.thanachot.autoItemInActionbar.manager.CommonRefillHandler;
import net.thanachot.autoItemInActionbar.manager.RemainderProviderItemHandler;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class PlayerListener
implements Listener {
    private final AutoItemInActionbar plugin;
    CommonRefillHandler commonRefillHandler = new CommonRefillHandler();
    RemainderProviderItemHandler remainderProviderItemHandler = new RemainderProviderItemHandler();

    public PlayerListener(AutoItemInActionbar plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.remainderProviderItemHandler.handle(player, ItemStack.of((Material)Material.BUCKET)), 1L);
    }

    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        ItemStack bucket = ItemStack.of((Material)event.getBucket());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.remainderProviderItemHandler.handle(player, bucket), 1L);
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItemInHand().clone();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.commonRefillHandler.handle(player, item), 1L);
    }

    @EventHandler
    public void PlayerDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItemDrop().getItemStack().clone();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.commonRefillHandler.handle(player, item), 1L);
    }

    @EventHandler
    public void onThrow(PlayerEggThrowEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getEgg().getItem().clone();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.commonRefillHandler.handle(player, item), 1L);
    }

    @EventHandler
    public void onPlayerItemBreak(PlayerItemBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getBrokenItem().clone();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.commonRefillHandler.handle(player, item), 1L);
    }

    @EventHandler
    public void onPlayerPotionSplash(PotionSplashEvent event) {
        ProjectileSource projectileSource = event.getPotion().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        if (event.getPotion().getItem().getType() != Material.SPLASH_POTION) {
            return;
        }
        ItemStack item = event.getPotion().getItem().clone();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.commonRefillHandler.handle(player, item), 1L);
    }

    @EventHandler
    public void onLingeringPotionSplashEvent(LingeringPotionSplashEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        if (event.getEntity().getItem().getType() != Material.LINGERING_POTION) {
            return;
        }
        ItemStack item = event.getEntity().getItem().clone();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.commonRefillHandler.handle(player, item), 1L);
    }

    @EventHandler
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack consumedItem = event.getItem().clone();
        Material consumeItemType = consumedItem.getType();
        switch (consumeItemType) {
            case MILK_BUCKET: 
            case SUSPICIOUS_STEW: 
            case MUSHROOM_STEW: 
            case RABBIT_STEW: 
            case BEETROOT_SOUP: 
            case POTION: 
            case HONEY_BOTTLE: {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.remainderProviderItemHandler.handle(player, consumedItem), 1L);
                break;
            }
            default: {
                if (!consumedItem.getType().isEdible()) break;
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.commonRefillHandler.handle(player, consumedItem), 1L);
            }
        }
    }
}

