/*
 * Decompiled with CFR 0.152.
 */
package net.thanachot.autoItemInActionbar.manager;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.thanachot.autoItemInActionbar.finder.Finder;
import net.thanachot.autoItemInActionbar.finder.FoundItem;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class BaseRefillHandler {
    private final Set<UUID> processing = ConcurrentHashMap.newKeySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Player player, ItemStack itemBeforeAction) {
        UUID id = player.getUniqueId();
        if (!this.processing.add(id)) {
            return;
        }
        try {
            if (player.isSneaking()) {
                return;
            }
            FoundItem foundItem = this.tryFindSource(player, itemBeforeAction);
            if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
                return;
            }
            if (this.isArmor(itemBeforeAction)) {
                return;
            }
            if (foundItem == null) {
                return;
            }
            this.performRefill(player, foundItem, itemBeforeAction);
            this.onRefillSuccess(player, foundItem, itemBeforeAction);
        }
        finally {
            this.processing.remove(id);
        }
    }

    protected abstract FoundItem tryFindSource(Player var1, ItemStack var2);

    protected void performRefill(Player player, FoundItem foundItem, ItemStack itemBeforeAction) {
        ItemStack sourceStack = foundItem.getItemStack();
        int amountInSource = sourceStack.getAmount();
        int maxStackSize = sourceStack.getMaxStackSize();
        int heldSlot = player.getInventory().getHeldItemSlot();
        int amountToMove = Math.min(amountInSource, maxStackSize);
        if (amountToMove <= 0) {
            return;
        }
        ItemStack refillStack = sourceStack.clone();
        refillStack.setAmount(amountToMove);
        player.getInventory().setItem(heldSlot, refillStack);
        sourceStack.setAmount(amountInSource - amountToMove);
        player.getInventory().setItem(foundItem.getFoundSlot(), (ItemStack)(sourceStack.getAmount() > 0 ? sourceStack : null));
    }

    protected void onRefillSuccess(Player player, FoundItem foundItem, ItemStack itemBeforeAction) {
        Component message = MiniMessage.miniMessage().deserialize((Object)"<b><gold>(<yellow>i</yellow>)</gold></b> <gradient:#9eee22:#55EA80:#246FD6>Auto Item In Actionbar</gradient>");
        player.sendActionBar(message);
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.6f, 0.7f);
    }

    public List<FoundItem> findAllShulker(Player player) {
        return Finder.findAllMatchByName((Inventory)player.getInventory(), "shulker_block", -1);
    }

    @Deprecated
    public boolean isFilledBucketType(ItemStack itemStack) {
        Material type = itemStack.getType();
        return type == Material.WATER_BUCKET || type == Material.LAVA_BUCKET || type == Material.MILK_BUCKET || type == Material.PUFFERFISH_BUCKET || type == Material.SALMON_BUCKET || type == Material.COD_BUCKET || type == Material.TROPICAL_FISH_BUCKET || type == Material.AXOLOTL_BUCKET;
    }

    public boolean isArmor(ItemStack itemStack) {
        String itemTypeName = itemStack.getType().name();
        return itemTypeName.endsWith("_HELMET") || itemTypeName.endsWith("_CHESTPLATE") || itemTypeName.endsWith("_LEGGINGS") || itemTypeName.endsWith("_BOOTS");
    }
}

