/*
 * Decompiled with CFR 0.152.
 */
package de.zaryon.nohunger.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class NoHungerConfig {
    private HungerMode mode = HungerMode.NORMAL;
    private boolean showHungerBar = true;
    private boolean peacefulHunger = false;
    private static final String CONFIG_FILE = "config/nohunger.json";
    private static NoHungerConfig INSTANCE;
    private static final Gson GSON;

    private NoHungerConfig() {
    }

    public static NoHungerConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NoHungerConfig();
            INSTANCE.loadConfig();
        }
        return INSTANCE;
    }

    public HungerMode getMode() {
        return this.mode;
    }

    public void setMode(HungerMode mode) {
        this.mode = mode;
    }

    public boolean isShowHungerBar() {
        return this.showHungerBar;
    }

    public void setShowHungerBar(boolean showHungerBar) {
        this.showHungerBar = showHungerBar;
    }

    public boolean isPeacefulHunger() {
        return this.peacefulHunger;
    }

    public void setPeacefulHunger(boolean peacefulHunger) {
        this.peacefulHunger = peacefulHunger;
    }

    public void loadConfig() {
        Path path = Path.of(CONFIG_FILE, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                NoHungerConfig loaded = (NoHungerConfig)GSON.fromJson((Reader)reader, NoHungerConfig.class);
                if (loaded != null) {
                    this.mode = loaded.mode;
                    this.showHungerBar = loaded.showHungerBar;
                    this.peacefulHunger = loaded.peacefulHunger;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void saveConfig() {
        try {
            Files.createDirectories(Path.of("config", new String[0]), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(Path.of(CONFIG_FILE, new String[0]), new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ConfigBuilder createConfigScreen() {
        ConfigBuilder builder = ConfigBuilder.create().setTitle((class_2561)class_2561.method_43471((String)"config.nohunger.settings"));
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.nohunger.category.general"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        EnumListEntry modeEntry = entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"config.nohunger.mode.select"), HungerMode.class, (Enum)this.mode).setEnumNameProvider(hm -> class_2561.method_43471((String)((HungerMode)((Object)hm)).getTranslationKey())).setTooltipSupplier(hm -> {
            if (hm == HungerMode.SURVIVAL_CAMPFIRE) {
                return Optional.of(new class_2561[]{class_2561.method_43471((String)hm.getTooltipKey())});
            }
            return Optional.of(new class_2561[]{class_2561.method_43471((String)hm.getTooltipKey())});
        }).setSaveConsumer(this::setMode).build();
        general.addEntry((AbstractConfigListEntry)modeEntry);
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"config.nohunger.show_hunger_bar"), this.showHungerBar).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.nohunger.show_hunger_bar.tooltip")}).setSaveConsumer(this::setShowHungerBar).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"config.nohunger.peaceful_hunger"), this.peacefulHunger).setTooltipSupplier(() -> Optional.of(new class_2561[]{class_2561.method_43471((String)"config.nohunger.peaceful_hunger.tooltip"), class_2561.method_43470((String)" (Only in Peaceful) ").method_27692(class_124.field_1054)})).setSaveConsumer(value -> {
            class_638 world = class_310.method_1551().field_1687;
            if (world != null && world.method_8407() == class_1267.field_5801) {
                this.setPeacefulHunger((boolean)value);
            } else {
                this.setPeacefulHunger(false);
            }
        }).setDefaultValue(false).build());
        builder.setSavingRunnable(this::saveConfig);
        return builder;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    public static enum HungerMode {
        NORMAL("config.nohunger.mode.normal", "config.nohunger.tooltip.normal"),
        VANILLA_SPECIAL_FOODS("config.nohunger.mode.vanilla_special_foods", "config.nohunger.tooltip.vanilla_special_foods"),
        ALL_FOODS("config.nohunger.mode.all_foods", "config.nohunger.tooltip.all_foods"),
        NO_FOOD("config.nohunger.mode.no_food", "config.nohunger.tooltip.no_food"),
        SURVIVAL_CAMPFIRE("config.nohunger.mode.survival_campfire", "config.nohunger.tooltip.survival_campfire");

        private final String translationKey;
        private final String tooltipKey;

        private HungerMode(String translationKey, String tooltipKey) {
            this.translationKey = translationKey;
            this.tooltipKey = tooltipKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String getTooltipKey() {
            return this.tooltipKey;
        }
    }
}

