/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.pickuptnt.mixin;

import com.iafenvoy.pickuptnt.Constants;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockItem.class})
public class BlockItemMixin {
    @Inject(method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlaceTnt(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = context.getItemInHand();
        if (!stack.is(Items.TNT) || stack.isEmpty() || !stack.has(Constants.FUSE_TYPE)) {
            return;
        }
        Level world = context.getLevel();
        if (!Blocks.TNT.isEnabled(world.enabledFeatures())) {
            return;
        }
        BlockPos pos = context.getClickedPos().offset(context.getClickedFace().getUnitVec3i());
        if (!world.getBlockState(pos).canBeReplaced()) {
            return;
        }
        PrimedTnt tnt = new PrimedTnt(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), null);
        tnt.setFuse(((Integer)stack.get(Constants.FUSE_TYPE)).intValue());
        world.addFreshEntity((Entity)tnt);
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        stack.shrink(1);
    }
}

