/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.pickuptnt.mixin;

import com.iafenvoy.pickuptnt.Constants;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    public ItemEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Shadow
    public abstract ItemStack getItem();

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onItemEntityTick(CallbackInfo ci) {
        ItemStack stack = this.getItem();
        if (!stack.is(Items.TNT) || stack.isEmpty()) {
            return;
        }
        if (stack.has(Constants.FUSE_TYPE)) {
            int fuse = (Integer)stack.get(Constants.FUSE_TYPE);
            if (fuse == 0) {
                if (!this.level().isClientSide) {
                    this.level().explode(null, this.getX(), this.getY(0.0625), this.getZ(), 4.0f * (float)stack.getCount(), Level.ExplosionInteraction.TNT);
                }
                this.discard();
                ci.cancel();
            } else {
                stack.set(Constants.FUSE_TYPE, (Object)(fuse - 1));
            }
        }
    }
}

