/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.pickuptnt.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockItem.class})
public class BlockItemMixin {
    @Inject(method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlaceTnt(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = context.getItemInHand();
        if (!stack.is(Items.TNT) || stack.isEmpty() || stack.getTag() == null || !stack.getTag().contains("fuse")) {
            return;
        }
        Level world = context.getLevel();
        if (!Blocks.TNT.isEnabled(world.enabledFeatures())) {
            return;
        }
        BlockPos pos = context.getClickedPos().offset(context.getClickedFace().getNormal());
        if (!world.getBlockState(pos).canBeReplaced()) {
            return;
        }
        stack.shrink(1);
        PrimedTnt tnt = new PrimedTnt(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), null);
        tnt.setFuse(stack.getTag().getInt("fuse"));
        world.addFreshEntity((Entity)tnt);
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
    }
}

