/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.pickuptnt.mixin;

import com.iafenvoy.pickuptnt.Constants;
import com.iafenvoy.pickuptnt.mixin.EntityAccessor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Inject(method={"inventoryTick(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;IZ)V"}, at={@At(value="HEAD")})
    private void onTickTnt(ItemStack stack, Level world, Entity entity, int slot, boolean selected, CallbackInfo ci) {
        if (!stack.is(Items.TNT) || stack.isEmpty()) {
            return;
        }
        if (stack.getTag() != null && stack.getTag().contains("fuse")) {
            int fuse = stack.getTag().getInt("fuse");
            if (fuse == 0) {
                if (!world.isClientSide) {
                    world.explode(null, entity.getX(), entity.getY(0.0625), entity.getZ(), 4.0f * (float)stack.getCount(), Level.ExplosionInteraction.TNT);
                }
                stack.setCount(0);
            } else {
                stack.getTag().putInt("fuse", fuse - 1);
            }
        }
    }

    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleTntBehaviour(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemStack stack = user.getItemInHand(hand);
        if (!stack.is(Items.TNT) || stack.isEmpty()) {
            return;
        }
        if (stack.getTag() != null && stack.getTag().contains("fuse") && !world.isClientSide) {
            PrimedTnt tnt = new PrimedTnt(world, user.getX(), user.getY(0.0625), user.getZ(), (LivingEntity)user);
            float pitch = user.getXRot();
            float yaw = user.getYRot();
            float f = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
            float g = -Mth.sin((float)((pitch + 0.0f) * ((float)Math.PI / 180)));
            float h = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
            RandomSource random = ((EntityAccessor)tnt).getRandom();
            Vec3 vec = new Vec3((double)f, (double)g, (double)h).normalize().add(random.triangle(0.0, 0.0172275), random.triangle(0.0, 0.0172275), random.triangle(0.0, 0.0172275)).scale(1.5);
            tnt.setYRot((float)(Mth.atan2((double)vec.x, (double)vec.z) * 57.2957763671875));
            tnt.setXRot((float)(Mth.atan2((double)vec.y, (double)vec.horizontalDistance()) * 57.2957763671875));
            tnt.yRotO = tnt.getYRot();
            tnt.xRotO = tnt.getXRot();
            Vec3 vec3d = user.getDeltaMovement();
            tnt.setDeltaMovement(vec.add(vec3d.x, user.onGround() ? 0.0 : vec3d.y, vec3d.z));
            tnt.setFuse(stack.getTag().getInt("fuse"));
            world.addFreshEntity((Entity)tnt);
            stack.shrink(1);
            cir.setReturnValue((Object)InteractionResultHolder.success((Object)stack));
        } else if (hand == InteractionHand.MAIN_HAND) {
            ItemStack offhand = user.getOffhandItem();
            if (offhand.is(Items.FLINT_AND_STEEL)) {
                offhand.hurtAndBreak(1, (LivingEntity)user, entity -> {});
            } else if (!offhand.is(Constants.PRIME_TNT) && EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.FIRE_ASPECT, (ItemStack)offhand) == 0) {
                return;
            }
            if (stack.getCount() == 1 || user.isShiftKeyDown()) {
                stack.getOrCreateTag().putInt("fuse", 80);
            } else {
                ItemStack newStack = stack.split(1);
                newStack.getOrCreateTag().putInt("fuse", 80);
                user.addItem(newStack);
            }
            user.playNotifySound(SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent((Entity)user, GameEvent.PRIME_FUSE, user.position());
            user.awardStat(Stats.ITEM_USED.get((Object)offhand.getItem()));
        }
    }
}

