/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.residence.enhance.lib.core;

import cn.handyplus.residence.enhance.lib.constants.BaseConstants;
import cn.handyplus.residence.enhance.lib.constants.VersionCheckEnum;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private JsonUtil() {
    }

    public static String toJson(Object obj) {
        return new Gson().toJson(obj);
    }

    public static <T> T toBean(String json, Class<T> t) {
        return (T)new Gson().fromJson(json, t);
    }

    public static <T> List<T> toList(String json, Class<T> t) {
        Type type = BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_21_4.getVersionId() ? TypeToken.getParameterized(List.class, (Type[])new Type[]{t}).getType() : new TypeToken<List<T>>(){}.getType();
        return (List)new Gson().fromJson(json, type);
    }

    public static Map<String, String> toMap(String json) {
        return (Map)new Gson().fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
    }

    public static Map<String, Object> toObjMap(String json) {
        return (Map)new Gson().fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    public static Map<String, String> objectToMap(Object obj) {
        return JsonUtil.toMap(JsonUtil.toJson(obj));
    }

    public static <T> boolean writeListToJson(List<T> list, File file) {
        boolean bl;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(list, (Appendable)writer);
            bl = true;
        }
        return bl;
    }
}

