/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.residence.enhance.lib.inventory;

import cn.handyplus.residence.enhance.lib.InitApi;
import cn.handyplus.residence.enhance.lib.core.CollUtil;
import cn.handyplus.residence.enhance.lib.core.LockUtil;
import cn.handyplus.residence.enhance.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.residence.enhance.lib.inventory.HandyInventory;
import cn.handyplus.residence.enhance.lib.inventory.HandyInventoryListener;
import cn.handyplus.residence.enhance.lib.inventory.HandyInventoryUtil;
import cn.handyplus.residence.enhance.lib.inventory.IHandyClickEvent;
import cn.handyplus.residence.enhance.lib.inventory.InventoryCheckParam;
import cn.handyplus.residence.enhance.lib.util.MessageUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HandyClickFactory {
    private static final HandyClickFactory INSTANCE = new HandyClickFactory();
    private static final Map<String, IHandyClickEvent> HANDY_CLICK_EVENT_MAP = new HashMap<String, IHandyClickEvent>();

    private HandyClickFactory() {
    }

    protected static HandyClickFactory getInstance() {
        return INSTANCE;
    }

    protected void init(List<IHandyClickEvent> handyClickEvents) {
        if (CollUtil.isEmpty(handyClickEvents)) {
            return;
        }
        for (IHandyClickEvent handyClickEvent : handyClickEvents) {
            HANDY_CLICK_EVENT_MAP.put(handyClickEvent.guiType(), handyClickEvent);
        }
        InitApi.PLUGIN.getServer().getPluginManager().registerEvents((Listener)new HandyInventoryListener(), (Plugin)InitApi.PLUGIN);
    }

    protected InventoryCheckParam inventoryCheck(InventoryClickEvent event) {
        InventoryCheckParam inventoryCheckParam = new InventoryCheckParam();
        inventoryCheckParam.setCheck(false);
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof HandyInventory)) {
            return inventoryCheckParam;
        }
        HandyInventory handyInventory = (HandyInventory)holder;
        Optional<Player> optionalPlayer = HandyInventoryUtil.getPlayer(event);
        if (!optionalPlayer.isPresent()) {
            return inventoryCheckParam;
        }
        if (event.getClick().isShiftClick() || event.getClick().isKeyboardClick()) {
            event.setCancelled(true);
            return inventoryCheckParam;
        }
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null || Material.AIR.equals((Object)currentItem.getType())) {
            event.setCancelled(handyInventory.isToCancel());
            return inventoryCheckParam;
        }
        if (event.isCancelled()) {
            return inventoryCheckParam;
        }
        handyInventory.setPlayer(optionalPlayer.get());
        String lockKey = handyInventory.getGuiType() + "_" + handyInventory.getPlayer().getUniqueId();
        handyInventory.setLockKey(lockKey);
        inventoryCheckParam.setCheck(true);
        inventoryCheckParam.setHandyInventory(handyInventory);
        return inventoryCheckParam;
    }

    protected void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        IHandyClickEvent handyClickEvent = HANDY_CLICK_EVENT_MAP.get(handyInventory.getGuiType());
        if (handyClickEvent == null) {
            return;
        }
        AtomicInteger lock = LockUtil.lock(handyInventory.getLockKey());
        if (lock.get() != 1) {
            return;
        }
        if (handyClickEvent.isAsync()) {
            this.onAsyncRawSlotClick(handyClickEvent, handyInventory, event);
            return;
        }
        this.rawSlotClickExecution(handyClickEvent, handyInventory, event);
    }

    private void onAsyncRawSlotClick(IHandyClickEvent handyClickEvent, HandyInventory handyInventory, InventoryClickEvent event) {
        HandySchedulerUtil.runTaskAsynchronously(() -> this.rawSlotClickExecution(handyClickEvent, handyInventory, event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rawSlotClickExecution(IHandyClickEvent handyClickEvent, HandyInventory handyInventory, InventoryClickEvent event) {
        try {
            handyClickEvent.rawSlotClick(handyInventory, event);
        }
        catch (RuntimeException exception) {
            MessageUtil.sendMessage(handyInventory.getPlayer(), exception.getMessage());
        }
        finally {
            LockUtil.unLock(handyInventory.getLockKey());
        }
    }
}

