/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.residence.enhance.lib.util;

import cn.handyplus.residence.enhance.lib.constants.BaseConstants;
import cn.handyplus.residence.enhance.lib.constants.HookPluginEnum;
import cn.handyplus.residence.enhance.lib.constants.VersionCheckEnum;
import cn.handyplus.residence.enhance.lib.core.CollUtil;
import cn.handyplus.residence.enhance.lib.core.JsonUtil;
import cn.handyplus.residence.enhance.lib.core.PatternUtil;
import cn.handyplus.residence.enhance.lib.core.StrUtil;
import cn.handyplus.residence.enhance.lib.util.AssertUtil;
import cn.handyplus.residence.enhance.lib.util.ItemStackUtil;
import cn.handyplus.residence.enhance.lib.util.LegacyUtil;
import cn.handyplus.residence.enhance.lib.util.MessageUtil;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BaseUtil {
    private static final double HEIGHT_254 = 254.0;
    private static final double HEIGHT_319 = 319.0;
    private static final String POINT = ".";

    private BaseUtil() {
    }

    public static Boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    public static Player getOnlinePlayer(CommandSender sender, String playerName, String msg) {
        if (StrUtil.isEmpty(playerName)) {
            AssertUtil.notPlayer(sender, msg);
            return (Player)sender;
        }
        Optional<Player> playerOpt = BaseUtil.getOnlinePlayer(playerName);
        AssertUtil.notTrue(!playerOpt.isPresent(), sender, msg);
        return playerOpt.get();
    }

    public static Optional<Player> getOnlinePlayer(String playerName) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static Optional<Player> getOnlinePlayer(UUID playerUuid) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null || !player.isOnline()) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    public static OfflinePlayer getOfflinePlayer(String playerName) {
        return Bukkit.getOfflinePlayer((String)playerName);
    }

    public static OfflinePlayer getOfflinePlayer(UUID playerUuid) {
        return Bukkit.getOfflinePlayer((UUID)playerUuid);
    }

    public static Boolean isNotPlayer(CommandSender sender) {
        return BaseUtil.isPlayer(sender) == false;
    }

    public static String replaceChatColor(String str) {
        if (StrUtil.isEmpty(str)) {
            return "";
        }
        String replaceStr = str.replace("&", "\u00a7");
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_16.getVersionId()) {
            return replaceStr;
        }
        return BaseUtil.translateColorCodes(replaceStr);
    }

    public static List<String> replaceChatColor(List<String> strList) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (CollUtil.isEmpty(strList)) {
            return loreList;
        }
        for (String lore : strList) {
            loreList.add(BaseUtil.replaceChatColor(lore));
        }
        return loreList;
    }

    public static String stripColor(String str) {
        if (StrUtil.isEmpty(str)) {
            return "";
        }
        return ChatColor.stripColor((String)BaseUtil.replaceChatColor(str));
    }

    public static UUID getUuid(String playerName) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        return offlinePlayer.getUniqueId();
    }

    public static String getLangMsg(String langMsg) {
        return BaseUtil.getLangMsg(langMsg, "");
    }

    public static String getLangMsg(String langMsg, String defaultMsg) {
        return BaseUtil.getLangMsg(langMsg, defaultMsg, true);
    }

    public static String getMsgNotColor(String langMsg) {
        return BaseUtil.getMsgNotColor(langMsg, "");
    }

    public static String getMsgNotColor(String langMsg, Map<String, String> replaceMap) {
        String msgNotColor = BaseUtil.getMsgNotColor(langMsg, "");
        if (replaceMap != null) {
            for (String key : replaceMap.keySet()) {
                msgNotColor = msgNotColor.replace(key, replaceMap.get(key));
            }
        }
        return msgNotColor;
    }

    public static String getMsgNotColor(String langMsg, String defaultMsg) {
        return BaseUtil.getLangMsg(langMsg, defaultMsg, false);
    }

    public static String getLangMsg(String langMsg, String defaultMsg, boolean isColor) {
        if (StrUtil.isEmpty(langMsg)) {
            return defaultMsg;
        }
        FileConfiguration langConfig = BaseConstants.LANG_CONFIG;
        if (langConfig == null) {
            return defaultMsg;
        }
        String msg = langConfig.getString(langMsg, defaultMsg);
        return isColor ? BaseUtil.replaceChatColor(msg) : msg;
    }

    public static String getDisplayName(ItemStack itemStack) {
        if (itemStack == null) {
            return BaseUtil.getDisplayName(null, Material.AIR.name());
        }
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        return BaseUtil.getDisplayName(itemMeta.getDisplayName(), itemStack.getType().name());
    }

    public static String getDisplayName(String displayName, String type) {
        String name;
        if (StrUtil.isNotEmpty(displayName)) {
            return displayName;
        }
        if (!BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            name = BaseConstants.JSON_CACHE_MAP.get("item.minecraft." + type.toLowerCase());
            if (name == null) {
                name = BaseConstants.JSON_CACHE_MAP.get("block.minecraft." + type.toLowerCase());
            }
            if (name != null) {
                return name;
            }
        }
        if (!BaseConstants.ITEM_JSON_CACHE_MAP.isEmpty() && (name = BaseConstants.ITEM_JSON_CACHE_MAP.get(type)) != null) {
            return name;
        }
        if (!BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.isEmpty() && (name = BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP.get(type)) != null) {
            return name;
        }
        return type;
    }

    public static String getEnchantmentLevel(String level) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return level;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault("enchantment.level." + level, level);
    }

    public static String getEffectName(String type) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return type;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault("effect.minecraft." + type.toLowerCase(), type);
    }

    public static String getEntityName(String type) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return type;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault("entity.minecraft." + type.toLowerCase(), type);
    }

    public static String getColorName(String color) {
        if (BaseConstants.JSON_CACHE_MAP.isEmpty()) {
            return color;
        }
        return BaseConstants.JSON_CACHE_MAP.getOrDefault("color.minecraft." + color.toLowerCase(), color);
    }

    public static void readJsonFileToItemJsonCacheMap(File file) {
        Optional<String> jsonOpt = BaseUtil.readJsonFile(file);
        if (jsonOpt.isPresent() && jsonOpt.get().length() > 1) {
            try {
                BaseConstants.ITEM_JSON_CACHE_MAP = JsonUtil.toMap(jsonOpt.get());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void readJsonFileToJsonCacheMap(File file) {
        try {
            Optional<String> jsonOpt = BaseUtil.readJsonFile(file);
            jsonOpt.ifPresent(s -> {
                BaseConstants.JSON_CACHE_MAP = JsonUtil.toMap(s);
            });
        }
        catch (Throwable ignored) {
            MessageUtil.sendConsoleDebugMessage("\u8bfb\u53d6item.json\u5f02\u5e38");
        }
    }

    public static Optional<String> readJsonFile(File fileName) {
        try {
            int ch;
            FileReader fileReader = new FileReader(fileName);
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(fileName.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            StringBuilder sb = new StringBuilder();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            fileReader.close();
            ((Reader)reader).close();
            return Optional.of(sb.toString());
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "readJsonFile \u53d1\u751f\u5f02\u5e38", e);
            return Optional.empty();
        }
    }

    public static boolean playerWorldIsNether(Player player) {
        return World.Environment.NETHER.equals((Object)player.getWorld().getEnvironment());
    }

    public static boolean playerWorldIsNotNether(Player player) {
        return !BaseUtil.playerWorldIsNether(player);
    }

    public static boolean worldTimeIsNight(Player player) {
        long time = player.getWorld().getTime() % 24000L;
        return time < 0L || time > 12400L;
    }

    public static boolean worldTimeIsNotNight(Player player) {
        return !BaseUtil.worldTimeIsNight(player);
    }

    public static boolean worldIsStorm(Player player) {
        return player.getWorld().hasStorm();
    }

    public static boolean worldIsNotStorm(Player player) {
        return !BaseUtil.worldIsStorm(player);
    }

    public static boolean isUnderRoof(Player player) {
        double height;
        Block block = player.getLocation().getBlock();
        double d = height = BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_18.getVersionId() ? 319.0 : 254.0;
        if (player.getLocation().getY() >= height) {
            return false;
        }
        while ((double)(block.getY() + 1) <= height) {
            if (Material.AIR.equals((Object)(block = block.getRelative(BlockFace.UP)).getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotUnderRoof(Player player) {
        return !BaseUtil.isUnderRoof(player);
    }

    public static int getFirstPluginVersion(Plugin plugin) {
        String version = plugin.getDescription().getVersion();
        String[] split = version.split("\\.");
        return Integer.parseInt(split[0]);
    }

    public static int getTwoPluginVersion(Plugin plugin) {
        String version = plugin.getDescription().getVersion();
        String[] split = version.split("\\.");
        return Integer.parseInt(split[1]);
    }

    public static Integer convertVersion(String version) {
        String[] versionParts;
        String cleanedVersion = version.replaceAll("[^\\d.]", "");
        if (!cleanedVersion.contains(POINT)) {
            return Integer.parseInt(cleanedVersion);
        }
        StringBuilder result = new StringBuilder();
        for (String part : versionParts = cleanedVersion.split("\\.")) {
            if (part.length() == 1) {
                result.append("0");
            }
            result.append(part);
        }
        return Integer.parseInt(result.toString());
    }

    public static Optional<Sound> getSound(String sound) {
        try {
            return Optional.of(LegacyUtil.getSound(sound));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, "getSound \u53d1\u751f\u5f02\u5e38", exception);
            }
            return Optional.empty();
        }
    }

    public static Optional<Biome> getBiome(String biome) {
        try {
            return Optional.of(LegacyUtil.getBiome(biome));
        }
        catch (Exception exception) {
            if (BaseConstants.DEBUG) {
                Bukkit.getLogger().log(Level.SEVERE, "getBiome \u53d1\u751f\u5f02\u5e38", exception);
            }
            return Optional.empty();
        }
    }

    public static Optional<EntityType> getEntityType(String key) {
        try {
            return Optional.of(EntityType.valueOf((String)key.toUpperCase()));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    public static Optional<Plugin> hook(String pluginName) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        return plugin != null && plugin.isEnabled() ? Optional.of(plugin) : Optional.empty();
    }

    public static boolean hook(String pluginName, String succeedMsgNode, String failureMsgNode) {
        Optional<Plugin> pluginOpt = BaseUtil.hook(pluginName);
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(pluginOpt.isPresent() ? succeedMsgNode : failureMsgNode));
        return pluginOpt.isPresent();
    }

    public static boolean hook(HookPluginEnum hookPluginEnum) {
        return BaseUtil.hook(hookPluginEnum.getName(), hookPluginEnum.getSuccessMsg(), hookPluginEnum.getFailMsg());
    }

    public static Optional<Plugin> hookToPlugin(HookPluginEnum hookPluginEnum) {
        Optional<Plugin> pluginOpt = BaseUtil.hook(hookPluginEnum.getName());
        MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(pluginOpt.isPresent() ? hookPluginEnum.getSuccessMsg() : hookPluginEnum.getFailMsg()));
        return pluginOpt;
    }

    private static String translateColorCodes(String str) {
        Matcher matcher = PatternUtil.RPG_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group();
            if (hex.length() == 5) {
                hex = hex.substring(0, 2) + BaseUtil.doubleCharacters(hex.substring(2));
            }
            matcher.appendReplacement(sb, ChatColor.of((String)hex.substring(1)).toString());
        }
        matcher.appendTail(sb);
        return ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)sb.toString());
    }

    private static String doubleCharacters(String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            sb.append(c);
            sb.append(c);
        }
        return sb.toString();
    }
}

