/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.residence.enhance.lib.util;

import cn.handyplus.residence.enhance.lib.InitApi;
import cn.handyplus.residence.enhance.lib.constants.BaseConstants;
import cn.handyplus.residence.enhance.lib.constants.LanguageTypeEnum;
import cn.handyplus.residence.enhance.lib.constants.VersionCheckEnum;
import cn.handyplus.residence.enhance.lib.core.CollUtil;
import cn.handyplus.residence.enhance.lib.core.StrUtil;
import cn.handyplus.residence.enhance.lib.util.BaseUtil;
import cn.handyplus.residence.enhance.lib.util.HandyHttpUtil;
import cn.handyplus.residence.enhance.lib.util.MessageUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class HandyConfigUtil {
    private static final String IS_CHECK_UPDATE = "isCheckUpdate";
    private static final String IS_CHECK_UPDATE_TO_OP_MSG = "isCheckUpdateToOpMsg";

    private HandyConfigUtil() {
    }

    public static FileConfiguration loadConfig() {
        BaseConstants.CONFIG = HandyConfigUtil.load("config.yml");
        return HandyConfigUtil.setConfig(BaseConstants.CONFIG);
    }

    public static FileConfiguration loadLangConfig(boolean isI18nJson) {
        if (BaseConstants.CONFIG == null) {
            HandyConfigUtil.loadConfig();
        }
        return HandyConfigUtil.loadLangConfig(BaseConstants.CONFIG.getString("language", "zh_CN"), isI18nJson);
    }

    public static FileConfiguration loadLangConfig(String language) {
        return HandyConfigUtil.loadLangConfig(language, false);
    }

    public static FileConfiguration loadLangConfig(String language, boolean isI18nJson) {
        String lang = "languages/" + language + ".yml";
        FileConfiguration langConfig = HandyConfigUtil.load(lang);
        if (langConfig == null) {
            langConfig = HandyConfigUtil.load("languages/zh_CN.yml");
        }
        BaseConstants.LANG_CONFIG = langConfig;
        if (isI18nJson) {
            LanguageTypeEnum languageType = LanguageTypeEnum.getByValue(language);
            if (languageType == null) {
                HandyConfigUtil.initItemJson();
            } else {
                HandyConfigUtil.initI18nJson(languageType);
            }
        }
        return langConfig;
    }

    public static FileConfiguration load(String child) {
        File langFile = new File(InitApi.PLUGIN.getDataFolder(), child);
        if (!langFile.exists()) {
            InputStream resource = InitApi.PLUGIN.getResource(child);
            if (resource == null) {
                MessageUtil.sendConsoleMessage("\u52a0\u8f7d\u6587\u4ef6\u5f02\u5e38\u539f\u56e0:\u6ca1\u6709\u53d1\u73b0\u5bf9\u5e94\u7684\u6587\u4ef6:" + child);
                return null;
            }
            InitApi.PLUGIN.saveResource(child, false);
        }
        return YamlConfiguration.loadConfiguration((File)langFile);
    }

    public static Map<String, FileConfiguration> loadDirectory(String directoryStr) {
        File[] spawnFileList;
        HashMap<String, FileConfiguration> map = new HashMap<String, FileConfiguration>();
        File directory = new File(InitApi.PLUGIN.getDataFolder(), directoryStr);
        if (!directory.exists()) {
            InitApi.PLUGIN.saveResource(directoryStr, false);
        }
        if ((spawnFileList = directory.listFiles()) == null) {
            return map;
        }
        for (File file : spawnFileList) {
            map.put(file.getName(), HandyConfigUtil.load(directoryStr + file.getName()));
        }
        return map;
    }

    public static boolean createNewFile(String fileName) {
        File file = new File(InitApi.PLUGIN.getDataFolder(), fileName);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            boolean rst = parent.mkdirs();
            MessageUtil.sendConsoleDebugMessage("\u521b\u5efa\u6587\u4ef6\u76ee\u5f55\u7ed3\u679c: " + rst);
        }
        if (!file.exists()) {
            return file.createNewFile();
        }
        return true;
    }

    public static File getOrCreateFile(String fileName) {
        File file = new File(InitApi.PLUGIN.getDataFolder(), fileName);
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            boolean rst = parent.mkdirs();
            MessageUtil.sendConsoleDebugMessage("\u521b\u5efa\u6587\u4ef6\u76ee\u5f55\u7ed3\u679c: " + rst);
        }
        if (!file.exists()) {
            boolean newFile = file.createNewFile();
            MessageUtil.sendConsoleDebugMessage("\u521b\u5efa\u6587\u4ef6\u7ed3\u679c: " + newFile);
        }
        return file;
    }

    public static void setPath(FileConfiguration fileConfiguration, String path, Object value, String child) {
        HandyConfigUtil.setPath(fileConfiguration, path, value, null, child);
    }

    public static void setPath(FileConfiguration fileConfiguration, String path, Object value, List<String> comments, String child) {
        try {
            fileConfiguration.set(path, value);
            if (CollUtil.isNotEmpty(comments) && BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_18.getVersionId()) {
                fileConfiguration.setComments(path, comments);
            }
            fileConfiguration.save(new File(InitApi.PLUGIN.getDataFolder(), child));
        }
        catch (IOException e) {
            Bukkit.getLogger().log(Level.SEVERE, "setPath \u53d1\u751f\u5f02\u5e38", e);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static void setPathIsNotContains(FileConfiguration fileConfiguration, String path, Object value, List<String> comments, String child) {
        if (fileConfiguration.contains(path)) {
            return;
        }
        HandyConfigUtil.setPath(fileConfiguration, path, value, comments, child);
    }

    public static boolean exists(String child) {
        File file = new File(InitApi.PLUGIN.getDataFolder(), child);
        return file.exists();
    }

    public static Map<String, String> getStringMapChild(FileConfiguration config, String type) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map<String, Object> values = HandyConfigUtil.getChildMap(config, type);
        for (String key : values.keySet()) {
            map.put(key, config.getString(type + "." + key));
        }
        return map;
    }

    public static Map<String, List<String>> getStringListMapChild(FileConfiguration config, String type) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        Map<String, Object> values = HandyConfigUtil.getChildMap(config, type);
        for (String key : values.keySet()) {
            map.put(key, config.getStringList(type + "." + key));
        }
        return map;
    }

    public static Map<String, Object> getChildMap(FileConfiguration config, String type) {
        if (StrUtil.isEmpty(type)) {
            return config.getValues(false);
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ConfigurationSection configurationSection = config.getConfigurationSection(type);
        if (configurationSection == null) {
            return map;
        }
        return configurationSection.getValues(false);
    }

    public static Set<String> getKey(FileConfiguration config, String type) {
        if (StrUtil.isEmpty(type)) {
            return config.getKeys(false);
        }
        HashSet<String> set = new HashSet<String>();
        ConfigurationSection configurationSection = config.getConfigurationSection(type);
        if (configurationSection == null) {
            return set;
        }
        return configurationSection.getKeys(false);
    }

    private static void initI18nJson(LanguageTypeEnum language) {
        File zhChFile = new File(InitApi.PLUGIN.getDataFolder(), language.getValue() + ".json");
        if (zhChFile.exists()) {
            BaseUtil.readJsonFileToJsonCacheMap(zhChFile);
        } else {
            HandyHttpUtil.getCloudI18nJson(language);
        }
        HandyConfigUtil.initItemJson();
        HandyHttpUtil.getCloudItem(language);
    }

    private static void initItemJson() {
        File itemFile = new File(InitApi.PLUGIN.getDataFolder(), "item.json");
        if (!itemFile.exists()) {
            InitApi.PLUGIN.saveResource("item.json", false);
        }
        try {
            BaseUtil.readJsonFileToItemJsonCacheMap(itemFile);
        }
        catch (Exception e) {
            MessageUtil.sendConsoleMessage("item.json \u52a0\u8f7d\u5931\u8d25,\u539f\u56e0:json\u683c\u5f0f\u5f02\u5e38");
        }
    }

    private static FileConfiguration setConfig(FileConfiguration config) {
        BaseConstants.DEBUG = BaseConstants.CONFIG.getBoolean("debug");
        BaseConstants.IS_CHECK_UPDATE = BaseConstants.CONFIG.getBoolean(IS_CHECK_UPDATE);
        BaseConstants.IS_CHECK_UPDATE_TO_OP_MSG = BaseConstants.CONFIG.getBoolean(IS_CHECK_UPDATE_TO_OP_MSG);
        return config;
    }
}

