/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.residence.enhance.lib.util;

import cn.handyplus.residence.enhance.lib.InitApi;
import cn.handyplus.residence.enhance.lib.constants.BaseConstants;
import cn.handyplus.residence.enhance.lib.constants.LanguageTypeEnum;
import cn.handyplus.residence.enhance.lib.constants.VersionCheckEnum;
import cn.handyplus.residence.enhance.lib.core.HttpUtil;
import cn.handyplus.residence.enhance.lib.core.JsonUtil;
import cn.handyplus.residence.enhance.lib.core.StrUtil;
import cn.handyplus.residence.enhance.lib.expand.adapter.HandyRunnable;
import cn.handyplus.residence.enhance.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.residence.enhance.lib.util.BaseUtil;
import cn.handyplus.residence.enhance.lib.util.MessageUtil;
import cn.handyplus.residence.enhance.lib.util.TextUtil;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class HandyHttpUtil {
    private static final String CLOUD_GET_URL = "https://admin.ljxmc.top/api/public/getItemName";
    private static final String IP_CHINA_URL = "https://admin.ljxmc.top/api/public/getIp";
    private static final String VERSION_URL = "https://ricedoc.handyplus.cn/version.json";

    private HandyHttpUtil() {
    }

    public static void checkVersion(Player player) {
        if (player != null) {
            if (!player.isOp()) {
                return;
            }
            if (!BaseConstants.IS_CHECK_UPDATE_TO_OP_MSG) {
                return;
            }
        }
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            String version = InitApi.PLUGIN.getDescription().getVersion();
            Optional<String> tagNameOpt = HandyHttpUtil.getOfficialVersion();
            if (!tagNameOpt.isPresent()) {
                return;
            }
            if (BaseUtil.convertVersion(tagNameOpt.get()) > BaseUtil.convertVersion(version)) {
                String oneMsg = ChatColor.GRAY + "_________________/ &e" + InitApi.PLUGIN.getDescription().getName() + ChatColor.GRAY + " \\_________________\n";
                TextComponent message = TextUtil.getInstance().init(oneMsg).build();
                String twoMsg = "&7| &a\u6700\u65b0\u7248\u672c: &d" + tagNameOpt.get() + " &a\u5f53\u524d\u7248\u672c: &d" + version + " &a\u70b9\u51fb&d&n\u6b64\u5904\u67e5\u770b&a\u66f4\u65b0\u5185\u5bb9 &7|\n";
                message.addExtra((BaseComponent)TextUtil.getInstance().init("     " + twoMsg).addClickUrl(InitApi.PLUGIN.getDescription().getWebsite()).build());
                message.addExtra((BaseComponent)TextUtil.getInstance().init(ChatColor.GRAY + "-----------------------------------------------").build());
                if (player == null) {
                    MessageUtil.sendConsoleMessage(twoMsg);
                } else {
                    MessageUtil.sendMessage(player, message);
                }
            }
        });
    }

    public static void getCloudItem(final LanguageTypeEnum language) {
        if (BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_13.getVersionId()) {
            return;
        }
        final AtomicInteger retryNumber = new AtomicInteger(6);
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
                        paramMap.put("version", BaseConstants.VERSION_CHECK_ENUM.getMainVersion());
                        paramMap.put("language", language.getValue());
                        String result = HttpUtil.get(HandyHttpUtil.CLOUD_GET_URL, paramMap);
                        if (StrUtil.isNotEmpty(result)) {
                            BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP = JsonUtil.toMap(result);
                        }
                        this.cancel();
                    }
                    catch (Throwable ignored) {
                        retryNumber.getAndDecrement();
                        if (retryNumber.get() >= 1) break block3;
                        this.cancel();
                    }
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 60L, 1200L);
    }

    public static String getIp() {
        try {
            return HttpUtil.get(IP_CHINA_URL);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            Bukkit.getLogger().log(Level.SEVERE, "getIp \u53d1\u751f\u5f02\u5e38", e);
            return "";
        }
    }

    public static void getCloudI18nJson(final LanguageTypeEnum language) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_13.getVersionId()) {
            return;
        }
        final AtomicInteger retryNumber = new AtomicInteger(6);
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        HttpUtil.downloadFile(language.getUrl(), InitApi.PLUGIN.getDataFolder(), language.getValue() + ".json");
                        File i18nFile = new File(InitApi.PLUGIN.getDataFolder(), language.getValue() + ".json");
                        if (i18nFile.exists()) {
                            BaseUtil.readJsonFileToJsonCacheMap(i18nFile);
                        }
                        this.cancel();
                    }
                    catch (Exception ignored) {
                        retryNumber.getAndDecrement();
                        if (retryNumber.get() >= 1) break block3;
                        this.cancel();
                    }
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 40L, 1200L);
    }

    private static Optional<String> getOfficialVersion() {
        try {
            String result = HttpUtil.get(VERSION_URL);
            if (StrUtil.isEmpty(result)) {
                return Optional.empty();
            }
            JsonObject jsonObject = JsonUtil.toBean(result, JsonObject.class);
            return Optional.ofNullable(jsonObject.get(InitApi.PLUGIN.getDescription().getName()).getAsString());
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }
}

