/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.residence.enhance.listener;

import cn.handyplus.residence.enhance.lib.annotation.HandyListener;
import cn.handyplus.residence.enhance.lib.core.CollUtil;
import cn.handyplus.residence.enhance.util.ConfigUtil;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

@HandyListener
public class PlayerCommandPreprocessEventListener
implements Listener {
    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        ClaimedResidence res = Residence.getInstance().getResidenceManager().getByLoc(player.getLocation());
        if (res == null) {
            return;
        }
        String message = event.getMessage();
        if ((message = message.replace("/", "")).isEmpty()) {
            return;
        }
        String[] messageList = message.split(" ");
        String command = messageList[0];
        List residenceNames = ConfigUtil.CONFIG.getStringList("name");
        if (CollUtil.isEmpty(residenceNames)) {
            return;
        }
        if (!CollUtil.contains(residenceNames, "*") && !CollUtil.contains(residenceNames, res.getName())) {
            return;
        }
        boolean isOp = ConfigUtil.CONFIG.getBoolean("isOp");
        if (!isOp && player.isOp()) {
            return;
        }
        boolean isOwner = ConfigUtil.CONFIG.getBoolean("isOwner");
        if (!isOwner) {
            String owner = res.getOwner();
            if (player.getName().equals(owner)) {
                return;
            }
        }
        List residenceCommands = ConfigUtil.CONFIG.getStringList("command");
        ArrayList<String> residenceCommandsLowerCases = new ArrayList<String>();
        for (String residenceCommand : residenceCommands) {
            residenceCommandsLowerCases.add(residenceCommand.toLowerCase());
        }
        if (!residenceCommandsLowerCases.contains(command.toLowerCase())) {
            return;
        }
        event.setCancelled(true);
        String msg = ConfigUtil.CONFIG.getString("msg");
        player.sendMessage(msg != null ? msg : "\u00a7a\u8fd9\u4e2a\u9886\u5730\u7981\u6b62\u6267\u884c\u8be5\u547d\u4ee4!");
    }
}

