/*
 * Decompiled with CFR 0.152.
 */
package de.pizzapost.minecraft_extra;

import de.pizzapost.minecraft_extra.block.ModBlockEntities;
import de.pizzapost.minecraft_extra.block.ModBlocks;
import de.pizzapost.minecraft_extra.block.custom.HoneyBerryBushBlock;
import de.pizzapost.minecraft_extra.commands.ModCommands;
import de.pizzapost.minecraft_extra.effect.ModEffects;
import de.pizzapost.minecraft_extra.entity.ModEntities;
import de.pizzapost.minecraft_extra.entity.custom.EndCrystalMobEntity;
import de.pizzapost.minecraft_extra.entity.custom.IceblazeEntity;
import de.pizzapost.minecraft_extra.entity.custom.SoapBubbleEntity;
import de.pizzapost.minecraft_extra.event.LightningStrikeHandler;
import de.pizzapost.minecraft_extra.event.SleepRegeneration;
import de.pizzapost.minecraft_extra.item.ModItemGroups;
import de.pizzapost.minecraft_extra.item.ModItems;
import de.pizzapost.minecraft_extra.item.custom.AttributeCoreScaledItem;
import de.pizzapost.minecraft_extra.item.custom.HardenedNetheriteAxeItem;
import de.pizzapost.minecraft_extra.keybinds.ModKeys;
import de.pizzapost.minecraft_extra.particle.ModParticles;
import de.pizzapost.minecraft_extra.sound.ModSounds;
import de.pizzapost.minecraft_extra.util.InventoryShuffler;
import de.pizzapost.minecraft_extra.util.ModLootTableModifiers;
import de.pizzapost.minecraft_extra.villager.CustomVillagerTrades;
import de.pizzapost.minecraft_extra.villager.ModVillagers;
import de.pizzapost.minecraft_extra.world.gen.ModWorldGeneration;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistryEvents;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2195;
import net.minecraft.class_2242;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2513;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3830;
import net.minecraft.class_5132;
import net.minecraft.class_5250;
import net.minecraft.class_5575;
import net.minecraft.class_5894;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftExtra
implements ModInitializer {
    public static final String MOD_ID = "minecraft_extra";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"minecraft_extra");
    private static final Set<class_1792> TARGET_ITEMS = Set.of(class_1802.field_20412, class_1802.field_29025, class_1802.field_8328, class_1802.field_8831, class_1802.field_20399, class_1802.field_8858, class_1802.field_20391, class_1802.field_28866);
    private static final Random RANDOM = new Random();

    public void onInitialize() {
        ModItemGroups.registerItemGroups();
        ModItems.registerModItems();
        ModLootTableModifiers.modifyLootTables();
        ModSounds.registerSounds();
        ModEntities.registerModEntities();
        LightningStrikeHandler.registerLightningStrikeEvent();
        ModEffects.registerEffects();
        ModBlocks.registerModBlocks();
        ModBlocks.registerCompostables();
        ModVillagers.registerVillagers();
        CustomVillagerTrades.registerVillagerTrades();
        ModCommands.registerModCommands();
        FuelRegistryEvents.BUILD.register((builder, context) -> builder.method_61762((class_1935)ModItems.ROTTEN_CHUNK, 150));
        ModWorldGeneration.generateModWorldGen();
        ModParticles.registerParticles();
        ModBlockEntities.registerBlockEntities();
        new SleepRegeneration().onInitialize();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (UUID uuid : new HashSet<UUID>(InventoryShuffler.getPlayers())) {
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player == null) continue;
                InventoryShuffler.tick(player);
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(this::onWorldTick);
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            for (class_3222 player : world.method_18456()) {
                class_1799 itemStack = player.method_5998(class_1268.field_5808);
                this.checkPlayerHandForEffect(player, (class_1937)world);
                AttributeCoreScaledItem.checkAndResetAttributes(player);
                if (player.method_19538().method_10214() >= 400.0 && player instanceof class_3222) {
                    class_3222 serverPlayer = player;
                    class_2960 advancementId = class_2960.method_60655((String)MOD_ID, (String)"gravity");
                    class_8779 advancement = serverPlayer.method_5682().method_3851().method_12896(advancementId);
                    if (advancement != null) {
                        serverPlayer.method_14236().method_12878(advancement, "imp");
                    }
                }
                if (ModKeys.silkTouchKey.method_1434() && itemStack.method_31574(ModItems.HARDENED_NETHERITE_PICKAXE)) {
                    class_2378 enchantmentRegistry = player.method_51469().method_30349().method_30530(class_7924.field_41265);
                    itemStack.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9099), 1);
                    continue;
                }
                if (ModKeys.silkTouchKey.method_1434() || !itemStack.method_31574(ModItems.HARDENED_NETHERITE_PICKAXE) || !itemStack.method_58657().toString().contains("minecraft:silk_touch")) continue;
                class_1661 inventory = player.method_31548();
                inventory.method_5447(inventory.method_67532(), ModItems.HARDENED_NETHERITE_PICKAXE.method_7854());
                class_1799 itemStack2 = player.method_5998(class_1268.field_5808);
                class_9326 changes = class_9326.method_57841().method_57854(class_9334.field_50239, (Object)itemStack.method_7964().method_27661().method_27692(class_124.field_1079).method_27692(class_124.field_1056)).method_57854(class_9334.field_49631, (Object)itemStack.method_7964().method_27661().method_27692(class_124.field_1079)).method_57852();
                itemStack2.method_59692(changes);
                class_2378 enchantmentRegistry = player.method_51469().method_30349().method_30530(class_7924.field_41265);
                itemStack2.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9131), 5);
                itemStack2.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9130), 3);
                itemStack2.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9119), 3);
                itemStack2.method_7974(itemStack.method_7919());
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (world.method_8419() && world.field_9229.method_43057() < 0.0025f) {
                List players = world.method_18456();
                if (players.isEmpty()) {
                    return;
                }
                class_3222 player = (class_3222)players.get(world.field_9229.method_43048(players.size()));
                double offsetX = (world.field_9229.method_43058() - 0.5) * 40.0;
                double offsetZ = (world.field_9229.method_43058() - 0.5) * 40.0;
                double targetX = player.method_23317() + offsetX;
                double targetZ = player.method_23321() + offsetZ;
                int topY = world.method_8624(class_2902.class_2903.field_13197, (int)Math.floor(targetX), (int)Math.floor(targetZ));
                double spawnY = topY + 50;
                class_1799 itemStack = new class_1799((class_1935)ModItems.WEATHER_ITEM);
                class_1542 itemEntity = new class_1542((class_1937)world, targetX, spawnY, targetZ, itemStack);
                world.method_8649((class_1297)itemEntity);
            }
            try {
                for (class_3222 player : world.method_18456()) {
                    class_5250 actionbarMessage;
                    class_243 pos;
                    class_243 pos2;
                    class_3222 serverPlayer;
                    this.checkUnderwaterForItem(player);
                    this.checkPlayerMovement(player);
                    if (player.method_51469().method_27983() == class_1937.field_25181 && player.method_23318() <= -55.0) {
                        if (!(player instanceof class_3222)) continue;
                        serverPlayer = player;
                        pos2 = player.method_19538();
                        player.method_48105(player.method_5682().method_3847(class_1937.field_25179), pos2.method_10216(), 499.0, pos2.method_10215(), EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
                        serverPlayer.method_24203(player.method_23317(), player.method_23318(), player.method_23321());
                        continue;
                    }
                    if (player.method_51469().method_27983() == class_1937.field_25179 && player.method_23318() >= 500.0) {
                        if (!(player instanceof class_3222)) continue;
                        serverPlayer = player;
                        boolean hasEnteredTheEnd = serverPlayer.method_14236().method_12882(serverPlayer.method_5682().method_3851().method_12896(class_2960.method_60654((String)"minecraft:story/enter_the_end"))).method_740();
                        if (hasEnteredTheEnd) {
                            pos = player.method_19538();
                            player.method_48105(player.method_5682().method_3847(class_1937.field_25181), pos.method_10216(), -40.0, pos.method_10215(), EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
                            serverPlayer.method_24203(player.method_23317(), player.method_23318(), player.method_23321());
                            class_243 boost = new class_243(0.0, 1.5, 0.0);
                            player.method_18799(player.method_18798().method_1019(boost));
                            player.field_6037 = true;
                            continue;
                        }
                        actionbarMessage = class_2561.method_43471((String)"actionbar.minecraft_extra.levitate_between_dimensions");
                        serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)actionbarMessage));
                        continue;
                    }
                    if (player.method_51469().method_27983() == class_1937.field_25179 && player.method_23318() <= -95.0) {
                        if (!(player instanceof class_3222)) continue;
                        serverPlayer = player;
                        boolean hasEnteredTheNether = serverPlayer.method_14236().method_12882(serverPlayer.method_5682().method_3851().method_12896(class_2960.method_60654((String)"minecraft:nether/root"))).method_740();
                        if (hasEnteredTheNether) {
                            pos = player.method_19538();
                            player.method_48105(player.method_5682().method_3847(class_1937.field_25180), pos.method_10216() * 8.0, 250.0, pos.method_10215() * 8.0, EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
                            serverPlayer.method_24203(player.method_23317(), player.method_23318(), player.method_23321());
                            continue;
                        }
                        actionbarMessage = class_2561.method_43471((String)"actionbar.minecraft_extra.levitate_between_dimensions");
                        serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)actionbarMessage));
                        continue;
                    }
                    if (player.method_51469().method_27983() != class_1937.field_25180 || !(player.method_23318() >= 251.0) || !(player instanceof class_3222)) continue;
                    serverPlayer = player;
                    pos2 = player.method_19538();
                    player.method_48105(player.method_5682().method_3847(class_1937.field_25179), pos2.method_10216() / 8.0, -80.0, pos2.method_10215() / 8.0, EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
                    serverPlayer.method_24203(player.method_23317(), player.method_23318(), player.method_23321());
                    class_243 boost = new class_243(0.0, 1.5, 0.0);
                    player.method_18799(player.method_18798().method_1019(boost));
                    player.field_6037 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.giveItemWithChance(serverPlayer, ModItems.EFFECT_GEM_STRENGTH.method_7854(), 0.001);
            }
            return class_1269.field_5811;
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (player.method_5998(class_1268.field_5808).method_31574(ModItems.HAMMER) && (state.method_26204() == class_2246.field_10340 || state.method_26204() == class_2246.field_28888 || state.method_26204() == class_2246.field_10445 || state.method_26204() == class_2246.field_29031)) {
                world.method_22352(pos, false);
                class_1799 itemStack = player.method_5998(class_1268.field_5808);
                itemStack.method_7974(itemStack.method_7919() + 1);
                world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), new class_1799((class_1935)class_2246.field_10255, 2)));
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_2960 advancementId = class_2960.method_60655((String)MOD_ID, (String)"hammer");
                    class_8779 advancement = serverPlayer.method_5682().method_3851().method_12896(advancementId);
                    if (advancement != null) {
                        serverPlayer.method_14236().method_12878(advancement, "imp");
                    }
                }
                return false;
            }
            return true;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (state.method_26204() == class_2246.field_9987) {
                if (player.method_5998(class_1268.field_5808).method_31574(ModItems.HARDENED_NETHERITE_PICKAXE)) {
                    world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, new class_1799((class_1935)class_1802.field_8542, 1)));
                } else if (player.method_5998(class_1268.field_5810).method_31574(ModItems.HARDENED_NETHERITE_PICKAXE)) {
                    world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, new class_1799((class_1935)class_1802.field_8542, 1)));
                }
            }
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            class_1799 itemStack = player.method_6047();
            if (itemStack.method_31574(ModItems.HARDENED_NETHERITE_AXE)) {
                if (itemStack.method_7942()) {
                    HardenedNetheriteAxeItem.postMine(itemStack, world, state, pos, player, class_1268.field_5808);
                }
            } else if (itemStack.method_31574(ModItems.HARDENED_NETHERITE_SHOVEL)) {
                if (itemStack.method_7942() && state.method_26204() == class_2246.field_10255) {
                    world.method_22352(pos, false);
                    player.method_7342(class_3468.field_15427.method_14956((Object)class_2246.field_10255), 1);
                    world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, new class_1799((class_1935)class_1802.field_8145, 2)));
                }
            } else if (state.method_26204() == ModBlocks.ASH_LAYER && !player.method_68878()) {
                int layers = (Integer)state.method_11654((class_2769)class_2741.field_12536);
                world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, new class_1799((class_1935)ModItems.ASH, layers)));
            }
            return true;
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.giveItemWithChance(serverPlayer, ModItems.EFFECT_GEM_HASTE.method_7854(), 1.0E-4);
            }
            if (!world.method_8608()) {
                class_2248 block = state.method_26204();
                if (block instanceof class_2302 && block != class_2246.field_10341) {
                    try {
                        int age = (Integer)state.method_11654((class_2769)class_2302.field_10835);
                        this.handleCropBlock(world, player, pos, block, age);
                    }
                    catch (Exception age) {
                        // empty catch block
                    }
                    return false;
                }
                if (block instanceof class_2513 || block instanceof class_2195) {
                    this.handleStemBlock(world, player, pos, state, block);
                    return false;
                }
                if (block == class_2246.field_16999) {
                    int age = (Integer)state.method_11654((class_2769)class_3830.field_17000);
                    this.handleSweetBerryBush(world, player, pos, block, age);
                    return false;
                }
                if (block == class_2246.field_28675 || block == class_2246.field_28676) {
                    this.handleCaveVines(world, player, pos, block);
                    return false;
                }
                if (block == class_2246.field_10341) {
                    int age = (Integer)state.method_11654((class_2769)class_2242.field_9962);
                    this.handleBeetroot(world, player, pos, block, age);
                    return false;
                }
                if (block == ModBlocks.HONEY_BERRY_BUSH) {
                    int age = (Integer)state.method_11654((class_2769)HoneyBerryBushBlock.field_17000);
                    this.handleHoneyBerryBush(world, player, pos, block, age);
                }
            }
            return true;
        });
        FabricDefaultAttributeRegistry.register(ModEntities.ICEBLAZE, (class_5132.class_5133)IceblazeEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SOAP_BUBBLE, (class_5132.class_5133)SoapBubbleEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.END_CRYSTAL_MOB, (class_5132.class_5133)EndCrystalMobEntity.createAttributes());
    }

    private void onWorldTick(class_3218 world) {
        for (class_1297 entity : world.method_18198((class_5575)class_1299.field_6052, e -> true)) {
            class_1542 itemEntity;
            class_1792 item;
            if (!(entity instanceof class_1542) || !TARGET_ITEMS.contains(item = (itemEntity = (class_1542)entity).method_6983().method_7909())) continue;
            this.adjustMaxStackSize(itemEntity);
        }
    }

    private void adjustMaxStackSize(class_1542 itemEntity) {
        itemEntity.method_6983().method_57379(class_9334.field_50071, (Object)99);
    }

    private void break_crop_message(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_5250 actionbarMessage = class_2561.method_43471((String)"actionbar.minecraft_extra.break_crop_message");
            serverPlayer.field_13987.method_14364((class_2596)new class_5894((class_2561)actionbarMessage));
        }
    }

    private void handleCropBlock(class_1937 world, class_1657 player, class_2338 pos, class_2248 block, int age) {
        if (age == ((class_2302)block).method_9827()) {
            if (player.method_5715()) {
                world.method_22352(pos, true);
            } else {
                world.method_22352(pos, true);
                world.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)class_2302.field_10835, (Comparable)Integer.valueOf(0)));
            }
        } else if (player.method_5715()) {
            world.method_22352(pos, true);
        } else {
            world.method_22352(pos, false);
            world.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)class_2302.field_10835, (Comparable)Integer.valueOf(age)));
            this.break_crop_message(player);
        }
    }

    private void handleStemBlock(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2248 block) {
        if (block instanceof class_2513) {
            int age = (Integer)state.method_11654((class_2769)class_2513.field_11584);
            if (player.method_5715()) {
                world.method_22352(pos, true);
            } else {
                world.method_22352(pos, false);
                world.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)class_2513.field_11584, (Comparable)Integer.valueOf(age)));
                this.break_crop_message(player);
            }
        } else if (block instanceof class_2195) {
            if (player.method_5715()) {
                world.method_22352(pos, true);
            } else {
                world.method_22352(pos, false);
                class_2350 facing = (class_2350)state.method_11654((class_2769)class_2195.field_9873);
                world.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)class_2195.field_9873, (Comparable)facing));
                this.break_crop_message(player);
            }
        }
    }

    private void handleBeetroot(class_1937 world, class_1657 player, class_2338 pos, class_2248 block, int age) {
        if (age == ((class_2242)block).method_9827()) {
            if (player.method_5715()) {
                world.method_22352(pos, true);
            } else {
                world.method_22352(pos, true);
                world.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)class_2242.field_9962, (Comparable)Integer.valueOf(0)));
            }
        } else if (player.method_5715()) {
            world.method_22352(pos, true);
        } else {
            world.method_22352(pos, false);
            world.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)class_2242.field_9962, (Comparable)Integer.valueOf(age)));
            this.break_crop_message(player);
        }
    }

    private void handleHoneyBerryBush(class_1937 world, class_1657 player, class_2338 pos, class_2248 block, int age) {
        if (player.method_5715()) {
            world.method_22352(pos, true);
        } else {
            world.method_22352(pos, false);
            world.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)HoneyBerryBushBlock.field_17000, (Comparable)Integer.valueOf(age)));
            this.break_crop_message(player);
            System.out.println("Warum funktioniert das nicht :(");
        }
    }

    private void handleSweetBerryBush(class_1937 world, class_1657 player, class_2338 pos, class_2248 block, int age) {
        if (player.method_5715()) {
            world.method_22352(pos, true);
        } else {
            world.method_22352(pos, false);
            world.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(age)));
            this.break_crop_message(player);
        }
    }

    private void handleCaveVines(class_1937 world, class_1657 player, class_2338 pos, class_2248 block) {
        if (player.method_5715()) {
            world.method_22352(pos, true);
        } else {
            world.method_8501(pos, block.method_9564());
            this.break_crop_message(player);
        }
    }

    private void checkPlayerHandForEffect(class_3222 player, class_1937 world) {
        boolean hasPushGem;
        boolean hasHasteGem = player.method_5998(class_1268.field_5808).method_31574(ModItems.EFFECT_GEM_HASTE) || player.method_5998(class_1268.field_5810).method_31574(ModItems.EFFECT_GEM_HASTE);
        boolean hasWaterBreathingGem = player.method_5998(class_1268.field_5808).method_31574(ModItems.EFFECT_GEM_WATER_BREATHING) || player.method_5998(class_1268.field_5810).method_31574(ModItems.EFFECT_GEM_WATER_BREATHING);
        boolean hasSlowFallingGem = player.method_5998(class_1268.field_5808).method_31574(ModItems.EFFECT_GEM_SLOW_FALLING) || player.method_5998(class_1268.field_5810).method_31574(ModItems.EFFECT_GEM_SLOW_FALLING);
        boolean hasStrengthGem = player.method_5998(class_1268.field_5808).method_31574(ModItems.EFFECT_GEM_STRENGTH) || player.method_5998(class_1268.field_5810).method_31574(ModItems.EFFECT_GEM_STRENGTH);
        boolean hasFireResistanceGem = player.method_5998(class_1268.field_5808).method_31574(ModItems.EFFECT_GEM_FIRE_RESISTANCE) || player.method_5998(class_1268.field_5810).method_31574(ModItems.EFFECT_GEM_FIRE_RESISTANCE);
        boolean hasJumpBoostGem = player.method_5998(class_1268.field_5808).method_31574(ModItems.EFFECT_GEM_JUMP_BOOST) || player.method_5998(class_1268.field_5810).method_31574(ModItems.EFFECT_GEM_JUMP_BOOST);
        boolean hasSpeedGem = player.method_5998(class_1268.field_5808).method_31574(ModItems.EFFECT_GEM_SPEED) || player.method_5998(class_1268.field_5810).method_31574(ModItems.EFFECT_GEM_SPEED);
        boolean bl = hasPushGem = player.method_5998(class_1268.field_5808).method_31574(ModItems.EFFECT_GEM_PUSH) || player.method_5998(class_1268.field_5810).method_31574(ModItems.EFFECT_GEM_PUSH);
        if (hasHasteGem) {
            player.method_6092(new class_1293(class_1294.field_5917, 10, 1, false, false));
        }
        if (hasWaterBreathingGem) {
            player.method_6092(new class_1293(class_1294.field_5923, 5, 0, false, false));
        }
        if (hasSlowFallingGem) {
            player.method_6092(new class_1293(class_1294.field_5906, 5, 0, false, false));
        }
        if (hasStrengthGem) {
            player.method_6092(new class_1293(class_1294.field_5910, 5, 0, false, false));
        }
        if (hasFireResistanceGem) {
            player.method_6092(new class_1293(class_1294.field_5918, 5, 0, false, false));
        }
        if (hasJumpBoostGem) {
            player.method_6092(new class_1293(class_1294.field_5913, 5, 8, false, false));
        }
        if (hasSpeedGem) {
            player.method_6092(new class_1293(class_1294.field_5904, 5, 0, false, false));
        }
        if (hasPushGem) {
            double angle = 0.0;
            for (int i = 0; i < 360; i += 10) {
                angle = Math.toRadians(i);
                double x = player.method_23317() + Math.cos(angle) * 1.5;
                double z = player.method_23321() + Math.sin(angle) * 1.5;
                class_3218 serverWorld = player.method_51469();
                serverWorld.method_65096((class_2394)ModParticles.EFFECT_GEM_PUSH_PARTICLE, x, player.method_23318() + 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            world.method_8390(class_1308.class, player.method_5829().method_1014(1.5), class_1297::method_5805).forEach(mob -> {
                if (mob.method_5864() == class_1299.field_6099 || mob.method_5864() == class_1299.field_49148 || mob.method_5864() == class_1299.field_47244 || mob.method_5864() == class_1299.field_6084 || mob.method_5864() == class_1299.field_6046 || mob.method_5864() == class_1299.field_6123 || mob.method_5864() == class_1299.field_6086 || mob.method_5864() == class_1299.field_6116 || mob.method_5864() == class_1299.field_6091 || mob.method_5864() == class_1299.field_6128 || mob.method_5864() == class_1299.field_6090 || mob.method_5864() == class_1299.field_6107 || mob.method_5864() == class_1299.field_6095 || mob.method_5864() == class_1299.field_6118 || mob.method_5864() == class_1299.field_21973 || mob.method_5864() == class_1299.field_6071 || mob.method_5864() == class_1299.field_6065 || mob.method_5864() == class_1299.field_6102 || mob.method_5864() == class_1299.field_6078 || mob.method_5864() == class_1299.field_22281 || mob.method_5864() == class_1299.field_25751 || mob.method_5864() == class_1299.field_6105 || mob.method_5864() == class_1299.field_6062 || mob.method_5864() == class_1299.field_6134 || mob.method_5864() == class_1299.field_6109 || mob.method_5864() == class_1299.field_6125 || mob.method_5864() == class_1299.field_6137 || mob.method_5864() == class_1299.field_6069 || mob.method_5864() == class_1299.field_6079 || mob.method_5864() == class_1299.field_6098 || mob.method_5864() == class_1299.field_6059 || mob.method_5864() == class_1299.field_6117 || mob.method_5864() == class_1299.field_38095 || mob.method_5864() == class_1299.field_6145 || mob.method_5864() == class_1299.field_6119 || mob.method_5864() == class_1299.field_6076 || mob.method_5864() == class_1299.field_23696 || mob.method_5864() == class_1299.field_6051 || mob.method_5864() == class_1299.field_6054) {
                    class_243 direction = mob.method_19538().method_1020(player.method_19538()).method_1029();
                    mob.method_5762(direction.field_1352 * 0.5, direction.field_1351 * 0.5 + 0.5, direction.field_1350 * 0.5);
                }
            });
        }
    }

    private void checkUnderwaterForItem(class_3222 player) {
        if (player.method_5869()) {
            this.giveItemWithChance(player, ModItems.EFFECT_GEM_WATER_BREATHING.method_7854(), 5.0E-5);
        }
    }

    private void checkPlayerMovement(class_3222 player) {
        if (player.method_5624()) {
            this.giveItemWithChance(player, ModItems.EFFECT_GEM_SPEED.method_7854(), 1.0E-5);
        }
        if (!player.method_24828() && player.method_18798().field_1351 > 0.0) {
            this.giveItemWithChance(player, ModItems.EFFECT_GEM_JUMP_BOOST.method_7854(), 1.0E-5);
        }
    }

    private void giveItemWithChance(class_3222 player, class_1799 item, double chance) {
        if (RANDOM.nextDouble() < chance) {
            player.method_7270(item.method_7972());
        }
    }

    public static class ClientInit
    implements ClientModInitializer {
        public void onInitializeClient() {
            ModKeys.registerKeyBindings();
        }
    }
}

