/*
 * Decompiled with CFR 0.152.
 */
package de.pizzapost.minecraft_extra.item.custom;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8779;
import net.minecraft.class_9291;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public class BiomeCompassItem
extends class_1792 {
    public BiomeCompassItem(class_1792.class_1793 settings) {
        super(settings);
    }

    private Pair<class_2338, class_6880<class_1959>> findNearestBiome(class_1657 player, class_2960 targetBiomeId) {
        class_1937 world = player.method_37908();
        class_2338 searchCenter = player.method_24515();
        com.google.common.base.Predicate biomePredicate = entry -> entry.method_40230().map(key -> key.method_29177().equals((Object)targetBiomeId)).orElse(false);
        class_5321 dimensionKey = world.method_27983();
        class_3218 targetWorld = world.method_8503().method_3847(dimensionKey);
        player.method_7353((class_2561)class_2561.method_43471((String)"actionbar.minecraft_extra.biome_compass_searching"), true);
        return targetWorld.method_42108((Predicate)biomePredicate, searchCenter, dimensionKey == class_1937.field_25180 ? 6000 : (dimensionKey == class_1937.field_25181 ? 10000 : 20000), 32, dimensionKey == class_1937.field_25180 ? 128 : 64);
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_3222 serverPlayer;
        class_8779 advancement;
        class_1799 itemStack = player.method_5998(hand);
        class_2960 advancementId = class_2960.method_60655((String)"minecraft_extra", (String)"biome_compass");
        if (player instanceof class_3222 && (advancement = (serverPlayer = (class_3222)player).method_5682().method_3851().method_12896(advancementId)) != null) {
            serverPlayer.method_14236().method_12878(advancement, "imp");
        }
        if (!world.method_8608()) {
            class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
            List biomes = biomeRegistry.method_10220().filter(biome -> {
                class_2960 id = biomeRegistry.method_10221(biome);
                return id != null && !id.method_12832().equals("empty");
            }).collect(Collectors.toList());
            if (biomes.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"actionbar.minecraft_extra.biome_compass_fail"), true);
                return class_1269.field_5814;
            }
            class_1959 selectedBiome = (class_1959)biomes.get(world.method_8409().method_43048(biomes.size()));
            class_2960 biomeId = biomeRegistry.method_10221((Object)selectedBiome);
            String formattedBiomeId = biomeId.toString().replace("minecraft:", "").replace("_", " ").replace("minecraft_extra:", "");
            Pair<class_2338, class_6880<class_1959>> result = this.findNearestBiome(player, biomeId);
            if (result != null) {
                class_2338 biomePos = (class_2338)result.getFirst();
                world.method_8396(null, player.method_24515(), class_3417.field_23199, class_3419.field_15248, 1.0f, 1.0f);
                class_9291 lodestoneTrackerComponent = new class_9291(Optional.of(class_4208.method_19443((class_5321)world.method_27983(), (class_2338)biomePos)), false);
                class_1799 compassStack = new class_1799((class_1935)class_1802.field_8251);
                compassStack.method_57379(class_9334.field_49614, (Object)lodestoneTrackerComponent);
                class_9326 changes = class_9326.method_57841().method_57854(class_9334.field_50239, (Object)class_2561.method_43470((String)formattedBiomeId)).method_57852();
                compassStack.method_59692(changes);
                if (!player.method_56992()) {
                    itemStack.method_7934(1);
                }
                int selectedSlot = player.method_31548().method_67532();
                class_1799 currentInHand = player.method_31548().method_5438(selectedSlot);
                if (currentInHand.method_7960()) {
                    player.method_31548().method_5447(selectedSlot, compassStack);
                } else if (!player.method_31548().method_7394(compassStack)) {
                    player.method_7328(compassStack, false);
                }
                player.method_31548().method_5431();
                int distance = (int)Math.round(Math.sqrt(player.method_24515().method_10262((class_2382)biomePos)));
                String formattedPos = String.format("%d, Y, %d", biomePos.method_10263(), biomePos.method_10260());
                player.method_7353((class_2561)class_2561.method_43470((String)(formattedBiomeId + ": " + formattedPos + " (" + distance + ")")), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"actionbar.minecraft_extra.biome_compass_fail", (Object[])new Object[]{biomeId.toString().replace("minecraft:", "").replace("_", " ").replace("minecraft_extra:", "")}), true);
                return class_1269.field_5814;
            }
        }
        return class_1269.field_5812;
    }
}

