/*
 * Decompiled with CFR 0.152.
 */
package de.pizzapost.minecraft_extra.item.custom;

import com.google.common.collect.ImmutableMap;
import de.pizzapost.minecraft_extra.effect.ModEffects;
import de.pizzapost.minecraft_extra.item.ModArmorMaterials;
import de.pizzapost.minecraft_extra.keybinds.ModKeys;
import de.pizzapost.minecraft_extra.particle.ModParticles;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10192;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ModArmorItem
extends class_1792 {
    private static final Map<class_1741, List<class_1293>> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ModArmorMaterials.HARDENED_NETHERITE_ARMOR_MATERIAL, List.of(new class_1293(class_1294.field_5917, 10, 2, false, false), new class_1293(class_1294.field_5924, 50, 0, false, false), new class_1293(class_1294.field_5910, 10, 1, false, false), new class_1293(class_1294.field_5904, 10, 1, false, false), new class_1293(ModEffects.SPIDER, 10, 0, false, false))).build();

    public ModArmorItem(class_1792.class_1793 settings) {
        super(settings);
    }

    private void removeHealthModifier(class_1657 player) {
        try {
            player.method_5996(class_5134.field_23716).method_6200(class_2960.method_60655((String)"minecraft_extra", (String)"hardened_netherite_armor_health"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (player.method_6032() > player.method_6063()) {
            player.method_6033(player.method_6063());
        }
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        if (!world.method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (this.hasFullSuitOfArmorOn(player)) {
                this.evaluateArmorEffects(player);
            } else {
                this.removeHealthModifier(player);
            }
        }
        super.method_7888(stack, world, entity, slot);
    }

    private void evaluateArmorEffects(class_1657 player) {
        for (Map.Entry<class_1741, List<class_1293>> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            class_1741 mapArmorMaterial = entry.getKey();
            List<class_1293> mapStatusEffects = entry.getValue();
            class_1937 class_19372 = player.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_65096((class_2394)ModParticles.HARDENED_NETHERITE_AMBIENT, player.method_23317(), player.method_23318() + 0.1, player.method_23321(), 1, 0.0, 0.0, 0.0, 1.0);
            }
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffects);
            if (!ModKeys.jumpBoostKey.method_1434()) continue;
            player.method_6092(new class_1293(class_1294.field_5913, 10, 4, false, false));
        }
    }

    private void addStatusEffectForMaterial(class_1657 player, class_1741 mapArmorMaterial, List<class_1293> mapStatusEffect) {
        boolean hasPlayerEffect = mapStatusEffect.stream().allMatch(statusEffectInstance -> player.method_6059(statusEffectInstance.method_5579()));
        if (!hasPlayerEffect) {
            for (class_1293 instance : mapStatusEffect) {
                player.method_6092(new class_1293(instance.method_5579(), instance.method_5584(), instance.method_5578(), instance.method_5591(), instance.method_5581()));
            }
            if (player.method_5996(class_5134.field_23716).method_6194() < 60.0) {
                try {
                    player.method_5996(class_5134.field_23716).method_26835(new class_1322(class_2960.method_60655((String)"minecraft_extra", (String)"hardened_netherite_armor_health"), 20.0, class_1322.class_1323.field_6328));
                    player.method_6033(Math.min(player.method_6032() + 20.0f, player.method_6063()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean hasFullSuitOfArmorOn(class_1657 player) {
        class_1799 boots = player.method_6118(class_1304.field_6166);
        class_1799 leggings = player.method_6118(class_1304.field_6172);
        class_1799 breastplate = player.method_6118(class_1304.field_6174);
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        return !helmet.method_7960() && !breastplate.method_7960() && !leggings.method_7960() && !boots.method_7960() && this.isEnchanted(helmet) && this.isEnchanted(breastplate) && this.isEnchanted(leggings) && this.isEnchanted(boots);
    }

    private boolean isEnchanted(class_1799 armor) {
        return !armor.method_7960() && armor.method_7942();
    }

    private boolean hasCorrectArmorOn(class_1741 material, class_1657 player) {
        class_1799 boots = player.method_6118(class_1304.field_6166);
        class_1799 leggings = player.method_6118(class_1304.field_6172);
        class_1799 breastplate = player.method_6118(class_1304.field_6174);
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        class_10192 equippableComponentBoots = (class_10192)boots.method_57353().method_58694(class_9334.field_54196);
        class_10192 equippableComponentLeggings = (class_10192)leggings.method_57353().method_58694(class_9334.field_54196);
        class_10192 equippableComponentBreastplate = (class_10192)breastplate.method_57353().method_58694(class_9334.field_54196);
        class_10192 equippableComponentHelmet = (class_10192)helmet.method_57353().method_58694(class_9334.field_54196);
        return ((class_5321)equippableComponentBoots.comp_3176().get()).equals(material.comp_3168()) == ((class_5321)equippableComponentLeggings.comp_3176().get()).equals(material.comp_3168()) && ((class_5321)equippableComponentBreastplate.comp_3176().get()).equals(material.comp_3168()) && ((class_5321)equippableComponentHelmet.comp_3176().get()).equals(material.comp_3168());
    }
}

