/*
 * Decompiled with CFR 0.152.
 */
package de.pizzapost.minecraft_extra.mixin;

import com.google.common.cache.CacheLoader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_3310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.include.com.google.common.collect.Lists;

@Mixin(targets={"net.minecraft.world.gen.feature.EndSpikeFeature$SpikeCache"})
public abstract class SpikeCacheMixin
extends CacheLoader<Long, List<class_3310.class_3181>> {
    @Inject(method={"load"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifySpikeGeneration(Long seed, CallbackInfoReturnable<List<class_3310.class_3181>> cir) {
        int newCount = 15;
        IntArrayList intArrayList = class_156.method_43251((IntStream)IntStream.range(0, newCount), (class_5819)class_5819.method_43049((long)seed));
        ArrayList spikes = Lists.newArrayList();
        for (int i = 0; i < newCount; ++i) {
            int x = class_3532.method_15357((double)(60.0 * Math.cos(2.0 * (-Math.PI + Math.PI / (double)newCount * (double)i))));
            int z = class_3532.method_15357((double)(60.0 * Math.sin(2.0 * (-Math.PI + Math.PI / (double)newCount * (double)i))));
            int radius = 3 + intArrayList.get(i) / 3;
            int height = 100 + intArrayList.get(i) * 3;
            boolean guarded = i % 2 == 0 || intArrayList.get(i) <= 3;
            spikes.add(new class_3310.class_3181(x, z, radius, height, guarded));
        }
        cir.setReturnValue((Object)spikes);
    }
}

