/*
 * Decompiled with CFR 0.152.
 */
package de.pizzapost.minecraft_extra.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class InventoryShuffler {
    private static final Map<UUID, ShuffleState> shufflingPlayers = new HashMap<UUID, ShuffleState>();

    public static void startShuffle(class_3222 player) {
        ArrayList<class_1799> currentItems = new ArrayList<class_1799>();
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            currentItems.add(player.method_31548().method_5438(i).method_7972());
        }
        shufflingPlayers.put(player.method_5667(), new ShuffleState(900, currentItems));
    }

    public static void tick(class_3222 player) {
        class_1799 stack3;
        UUID uuid = player.method_5667();
        ShuffleState state = shufflingPlayers.get(uuid);
        if (state == null) {
            return;
        }
        if (state.ticksLeft <= 0) {
            player.method_31548().method_5448();
            for (class_1799 stack2 : state.originalItems) {
                player.method_31548().method_7394(stack2.method_7972());
            }
            shufflingPlayers.remove(uuid);
            return;
        }
        ArrayList<class_1799> shuffled = new ArrayList<class_1799>(state.originalItems);
        Collections.shuffle(shuffled);
        player.method_31548().method_5448();
        for (class_1799 stack3 : shuffled) {
            player.method_31548().method_7394(stack3.method_7972());
        }
        --state.ticksLeft;
        stack3 = player.method_51469();
        if (stack3 instanceof class_3218) {
            class_1799 serverWorld = stack3;
            Random random = new Random();
            serverWorld.method_8396(null, player.method_24515(), class_3417.field_15197, class_3419.field_15248, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public static boolean isShuffling(UUID player) {
        return shufflingPlayers.containsKey(player);
    }

    public static Set<UUID> getPlayers() {
        return shufflingPlayers.keySet();
    }

    private static class ShuffleState {
        int ticksLeft;
        final List<class_1799> originalItems;

        ShuffleState(int ticks, List<class_1799> items) {
            this.ticksLeft = ticks;
            this.originalItems = new ArrayList<class_1799>(items);
        }
    }
}

