/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="patchoulibooks", name="patchoulibooks", category="patchoulibooks")
@Config.LangKey(value="config.patchoulibooks")
public class PBConfig {
    @Config.Name(value="debug")
    @Config.LangKey(value="config.patchoulibooks.debug")
    public static final Debug DEBUG = new Debug();
    @Config.Name(value="general")
    @Config.LangKey(value="config.patchoulibooks.general")
    public static final General GENERAL = new General();
    @Config.Name(value="jei_hei")
    @Config.LangKey(value="config.patchoulibooks.jei")
    public static final JustEnoughItems JEI = new JustEnoughItems();
    @Config.Name(value="inventory_button")
    @Config.LangKey(value="config.patchoulibooks.inventory_button")
    public static final InventoryButton INVENTORY_BUTTON = new InventoryButton();

    @Mod.EventBusSubscriber(modid="patchoulibooks")
    public static class ConfigEventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("patchoulibooks")) {
                ConfigManager.sync((String)"patchoulibooks", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class JustEnoughItems {
        @Config.Name(value="Open JEI from Books")
        @Config.Comment(value={"Enable opening JEI for items in Patchouli books."})
        public boolean enableJEIinBooks = true;
        @Config.Name(value="Open Patchouli Book from JEI")
        @Config.Comment(value={"Enable opening Patchouli books from JEI.", "Each book with a matching item will be displayed next to the recipe.", "If there is more than one book, the books will be displayed in a grid."})
        public boolean enableBooksInJEI = true;
        @Config.Name(value="Book Blacklist")
        @Config.Comment(value={"Prevent books from showing up in JEI."})
        public String[] blacklistBook = new String[]{"patchoulibooks:patchoulibooks"};
    }

    public static class InventoryButton {
        @Config.Name(value="[1] Enable Inventory Button")
        @Config.Comment(value={"Enable the inventory button for Patchouli books.", "On click it will open a list of all loaded books.", "The button will be displayed only if the is no book specified in the patchouli config and 'addUniqueInventoryButton' is set to false."})
        @Config.RequiresMcRestart
        public boolean enableInventoryButton = true;
        @Config.Name(value="[2] Add unique inventory button")
        @Config.Comment(value={"Instead of overriding the patchouli inventory button, add a new button.", "This requires the inventory button to be enabled."})
        public boolean addUniqueInventoryButton = true;
        @Config.Name(value="[3] Button Anchor")
        @Config.Comment(value={"Anchor position of the inventory button."})
        public Anchor buttonAnchor = Anchor.TOP_LEFT;
        @Config.Name(value="[4] Button Offset X")
        @Config.Comment(value={"Offset of the button from the anchor position on the x-axis."})
        public int buttonXPosition = 134;
        @Config.Name(value="[5] Button Offset Y")
        @Config.Comment(value={"Offset of the button from the anchor position on the y-axis."})
        public int buttonYPosition = 61;
    }

    public static class General {
        @Config.Name(value="[1] Enable Recipes")
        @Config.Comment(value={"Add default recipes for Patchouli Books books."})
        @Config.RequiresMcRestart
        public boolean enableRecipes = true;
        @Config.Name(value="[2] Enable Pamphlets for everyone")
        @Config.Comment(value={"Enable Pamphlets for all books if there is only one category, which has less than 15 entries.", "You can still create pamphlets manually by adding the 'pamphlet' tag to a book.json."})
        public boolean enablePamphlets = false;
        @Config.Name(value="[3] Improve Recipe Lookup")
        @Config.Comment(value={"Improve recipe lookup by checking for output instead of recipe id.", "This is untested with books added by other mods. User added books work fine."})
        public boolean improveRecipeLookup = false;
    }

    public static class Debug {
        @Config.Name(value="Enable Debug")
        @Config.Comment(value={"Enable debug mode."})
        @Config.RequiresMcRestart
        public boolean enableDebug = false;
    }

    public static enum Anchor {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER;

    }
}

