/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.events;

import io.enderdev.patchoulibooks.PBConfig;
import io.enderdev.patchoulibooks.integration.patchouli.ButtonScreen;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class InventoryBookEvent {
    private static final int BUTTON_ID = 801;
    private static final ResourceLocation BUTTON_ICON = new ResourceLocation("patchoulibooks", "textures/gui/button.png");
    private GuiButtonImage buttonBook;
    private int[] pos;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void guiOpen(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (!(gui instanceof GuiInventory) || !PBConfig.INVENTORY_BUTTON.addUniqueInventoryButton) {
            return;
        }
        this.pos = this.calculateButtonPosition(gui);
        this.buttonBook = new GuiButtonImage(801, this.pos[0], this.pos[1], 20, 18, 14, 0, 19, BUTTON_ICON);
        event.getButtonList().add(this.buttonBook);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void guiButtonClick(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (!(event.getGui() instanceof GuiInventory)) {
            return;
        }
        if (event.getButton().equals(this.buttonBook)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new ButtonScreen(Arrays.asList(BookRegistry.INSTANCE.books.values().toArray(new Book[0]))));
            this.buttonBook.func_146113_a(Minecraft.func_71410_x().func_147118_V());
        } else {
            this.pos = this.calculateButtonPosition(event.getGui());
            int xPosition = this.pos[0];
            int yPosition = this.pos[1];
            this.buttonBook.func_191746_c(xPosition, yPosition);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int[] calculateButtonPosition(GuiScreen gui) {
        int x = 0;
        int y = 0;
        int width = ((GuiInventory)gui).getXSize();
        int height = ((GuiInventory)gui).getYSize();
        switch (PBConfig.INVENTORY_BUTTON.buttonAnchor) {
            case TOP: {
                x = width / 2;
                y = 0;
                break;
            }
            case RIGHT: {
                x = width;
                y = height / 2;
                break;
            }
            case BOTTOM: {
                x = width / 2;
                y = height;
                break;
            }
            case LEFT: {
                x = 0;
                y = height / 2;
                break;
            }
            case TOP_LEFT: {
                x = 0;
                y = 0;
                break;
            }
            case TOP_RIGHT: {
                x = width;
                y = 0;
                break;
            }
            case BOTTOM_RIGHT: {
                x = width;
                y = height;
                break;
            }
            case BOTTOM_LEFT: {
                x = 0;
                y = height;
                break;
            }
            case CENTER: {
                x = width / 2;
                y = height / 2;
            }
        }
        x += ((GuiInventory)gui).getGuiLeft();
        y += ((GuiInventory)gui).getGuiTop();
        return new int[]{x += PBConfig.INVENTORY_BUTTON.buttonXPosition, y += PBConfig.INVENTORY_BUTTON.buttonYPosition};
    }
}

