/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.integration.jei;

import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableIngredient;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.plugins.vanilla.ingredients.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class PatchouliButton
extends GuiIconButtonSmall {
    private final Book book;
    private final ItemStack itemStack;
    private final String book_name;

    public PatchouliButton(int buttonId, int x, int y, int widthIn, int heightIn, Book book, ItemStack itemStack) {
        super(buttonId, x, y, widthIn, heightIn, (IDrawable)new DrawableIngredient((Object)book.getBookItem(), (IIngredientRenderer)new ItemStackRenderer()));
        this.book = book;
        this.itemStack = itemStack;
        this.book_name = book.getBookItem().func_82833_r();
    }

    public void drawToolTip(Minecraft mc, int mouseX, int mouseY) {
        String tooltipTransfer = I18n.func_135052_a((String)"patchoulibooks.jei.openbook", (Object[])new Object[]{this.book_name});
        if (this.field_146123_n && this.field_146125_m) {
            TooltipRenderer.drawHoveringText((Minecraft)mc, (String)tooltipTransfer, (int)mouseX, (int)mouseY);
        }
    }

    public void openBook() {
        Pair<BookEntry, Integer> hover = this.getMapping();
        if (hover != null) {
            BookEntry entry = (BookEntry)hover.getLeft();
            if (!entry.isLocked()) {
                int page = (Integer)hover.getRight();
                GuiBook curr = this.book.contents.getCurrentGui();
                this.book.contents.currentGui = new GuiBookEntry(this.book, entry, page);
                this.book.contents.guiStack.push(curr);
            }
            if (!this.book.contents.getCurrentGui().canBeOpened()) {
                this.book.contents.currentGui = null;
                this.book.contents.guiStack.clear();
            }
            this.book.contents.openLexiconGui(this.book.contents.getCurrentGui(), false);
        }
    }

    public Book getBook() {
        return this.book;
    }

    private BookEntry getEntry() {
        return this.book.contents.entries.values().stream().filter(bookEntry -> bookEntry.isStackRelevant(this.itemStack)).findFirst().orElse(null);
    }

    private Pair<BookEntry, Integer> getMapping() {
        return (Pair)this.book.contents.recipeMappings.get(ItemStackUtil.wrapStack((ItemStack)this.itemStack));
    }

    public boolean isUnlocked() {
        return this.getEntry() != null && !this.getEntry().isLocked();
    }
}

