/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.integration.patchouli;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import vazkii.patchouli.common.book.Book;

public class BookExtension
extends Book {
    private final Map<String, String> MY_MACROS = new HashMap<String, String>(){
        {
            this.put("$(pb)", "$(l)$(#606)Patchouli Books$()");
            this.put("<pb>", "$(pb)");
            this.put("<c_black>", "$(#000)");
            this.put("<c_dark_blue>", "$(#00A)");
            this.put("<c_dark_green>", "$(#0A0)");
            this.put("<c_dark_aqua>", "$(#0AA)");
            this.put("<c_dark_red>", "$(#A00)");
            this.put("<c_dark_purple>", "$(#A0A)");
            this.put("<c_gold>", "$(#FA0)");
            this.put("<c_gray>", "$(#AAA)");
            this.put("<c_dark_gray>", "$(#555)");
            this.put("<c_blue>", "$(#55F)");
            this.put("<c_green>", "$(#5F5)");
            this.put("<c_aqua>", "$(#5FF)");
            this.put("<c_red>", "$(#F55)");
            this.put("<c_purple>", "$(#F5F)");
            this.put("<c_yellow>", "$(#FF5)");
            this.put("<c_white>", "$(#FFF)");
            this.put("<b>", "$(l)");
            this.put("<i>", "$(o)");
            this.put("</>", "$()");
            this.put("<item>", "$(#b0b)");
            this.put("<mark>", "$(#490)");
            this.put("<li>", "$(li)");
            this.put("<li2>", "$(li2)");
            this.put("<br>", "$(br)");
            this.put("<2br>", "$(br)$(br)");
            this.put("<l>(", "$(l:");
            this.put("</l>", "$(/l)");
            this.put("<k>(", "$(k:");
        }
    };
    @SerializedName(value="author")
    public String bookAuthor = "_MasterEnderman_";
    @SerializedName(value="link_curseforge")
    public String linkCurseforge = "https://www.curseforge.com/minecraft";
    @SerializedName(value="link_github")
    public String linkGitHub = "https://github.com";
    @SerializedName(value="link_wiki")
    public String linkWiki = "https://minecraft.wiki";
    @SerializedName(value="book_plus")
    public boolean bookPlus = false;
    @SerializedName(value="disabled")
    public boolean bookDisabled = false;
    @SerializedName(value="pamphlet")
    public boolean isPamphlet = true;

    public void build(ModContainer owner, ResourceLocation resource, boolean external) {
        this.owner = owner;
        this.resourceLoc = resource;
        this.isExternal = this.bookPlus;
        if (!this.isExternal) {
            this.showProgress = false;
            this.model = String.format("%s:book_%s", "patchoulibooks", this.resourceLoc.func_110623_a());
            this.name = String.format("%s Guide", this.getOriginalOwner(this.resourceLoc));
            this.fillerResource = new ResourceLocation("patchoulibooks", String.format("textures/gui/filler/%s.png", this.resourceLoc.func_110623_a()));
            this.version = "0.2.7";
            this.landingText = String.format("This Book documents the items and blocks in the <mod> mod. It is part of the <pb> mod that tries to document as many mods as possible.<br>All information about <mod> are taken from these sources:<li>$(l:%s)Curseforge$(/l)<li>$(l:%s)GitHub$(/l)<li>$(l:%s)Wiki$(/l)", this.linkCurseforge, this.linkGitHub, this.linkWiki);
        } else {
            this.fillerResource = new ResourceLocation("patchoulibooks", "textures/gui/filler/external.png");
        }
        this.MY_MACROS.put("$(mod)", "$(l)$(#490)" + this.getOriginalOwner(this.resourceLoc) + "$()");
        this.MY_MACROS.put("<mod>", "$(mod)");
        boolean bl = this.isExtension = !this.extend.isEmpty();
        if (!this.isExtension) {
            this.modelResourceLoc = new ModelResourceLocation(this.model, "inventory");
            this.bookResource = new ResourceLocation(this.bookTexture);
            this.craftingResource = new ResourceLocation(this.craftingTexture);
            this.textColor = 0xFF000000 | Integer.parseInt(this.textColorRaw, 16);
            this.headerColor = 0xFF000000 | Integer.parseInt(this.headerColorRaw, 16);
            this.nameplateColor = 0xFF000000 | Integer.parseInt(this.nameplateColorRaw, 16);
            this.linkColor = 0xFF000000 | Integer.parseInt(this.linkColorRaw, 16);
            this.linkHoverColor = 0xFF000000 | Integer.parseInt(this.linkHoverColorRaw, 16);
            this.progressBarColor = 0xFF000000 | Integer.parseInt(this.progressBarColorRaw, 16);
            this.progressBarBackground = 0xFF000000 | Integer.parseInt(this.progressBarBackgroundRaw, 16);
            for (String m : this.MY_MACROS.keySet()) {
                if (this.macros.containsKey(m)) continue;
                this.macros.put(m, this.MY_MACROS.get(m));
            }
        }
    }

    private String getOriginalOwner(ResourceLocation resourceLoc) {
        ModContainer mod_owner = Loader.instance().getActiveModList().stream().filter(modContainer -> modContainer.getModId().equals(resourceLoc.func_110623_a())).findFirst().orElse(this.owner);
        switch (mod_owner.getModId()) {
            case "ic2": {
                return "IC2C";
            }
            case "buildcraftlib": {
                return "BuildCraft";
            }
            case "embers": {
                return "Embers UEL";
            }
        }
        return mod_owner.getName();
    }
}

