/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.integration.patchouli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.common.book.Book;

public class ButtonScreen
extends GuiScreen {
    private static final ResourceLocation PATCHOULI_BUTTON = new ResourceLocation("patchoulibooks", "textures/gui/patchouli_button.png");
    private static final int BOOKS_PER_PAGE = 6;
    private final List<Book> bookList = new ArrayList<Book>();
    private int page = 0;

    public ButtonScreen(List<Book> list) {
        list.stream().sorted(Comparator.comparing(a -> a.name)).filter(a -> !a.name.isEmpty()).forEach(this.bookList::add);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(PATCHOULI_BUTTON);
        this.func_73729_b(this.field_146294_l / 2 - 73, this.field_146295_m / 2 - 90, 0, 0, 146, 180);
        String title = I18n.func_135052_a((String)"patchoulibooks.gui.inventory_button.title", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, this.field_146295_m / 2 - 75, 0x55AA00);
        int maxPageOffset = this.bookList.size() % 6 == 0 ? 0 : 1;
        String pageText = I18n.func_135052_a((String)"patchoulibooks.gui.inventory_button.page", (Object[])new Object[]{this.page + 1, this.bookList.size() / 6 + maxPageOffset});
        this.field_146289_q.func_78276_b(pageText, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(pageText) / 2, this.field_146295_m / 2 + 65, 0x999999);
        if (this.bookList.size() > 6) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(PATCHOULI_BUTTON);
            if (this.page > 0) {
                if (this.isPointWithinBounds(this.field_146294_l / 2 - 55, this.field_146295_m / 2 + 65, 18, 10, mouseX, mouseY)) {
                    this.func_73729_b(this.field_146294_l / 2 - 55, this.field_146295_m / 2 + 65, 18, 190, 18, 10);
                } else {
                    this.func_73729_b(this.field_146294_l / 2 - 55, this.field_146295_m / 2 + 65, 0, 190, 18, 10);
                }
            }
            if (this.bookList.size() > this.page * 6 + 6) {
                if (this.isPointWithinBounds(this.field_146294_l / 2 + 30, this.field_146295_m / 2 + 65, 18, 10, mouseX, mouseY)) {
                    this.func_73729_b(this.field_146294_l / 2 + 30, this.field_146295_m / 2 + 65, 18, 180, 18, 10);
                } else {
                    this.func_73729_b(this.field_146294_l / 2 + 30, this.field_146295_m / 2 + 65, 0, 180, 18, 10);
                }
            }
        }
        RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
        for (Book book : this.bookList) {
            int index = this.bookList.indexOf(book);
            int page = index / 6;
            int offset = index % 6;
            if (page != this.page) continue;
            int x = this.field_146294_l / 2 - 62;
            int y = this.field_146295_m / 2 - 60 + offset * 20;
            RenderHelper.func_74520_c();
            itemRenderer.func_180450_b(book.getBookItem(), x + 2, y + 2);
            RenderHelper.func_74518_a();
            String text = I18n.func_135052_a((String)book.name, (Object[])new Object[0]);
            if (this.field_146289_q.func_78256_a(text) > 90) {
                text = text.substring(0, 14) + "...";
            }
            if (this.isPointWithinBounds(x, y, 110, 18, mouseX, mouseY)) {
                this.field_146289_q.func_78276_b(text, x + 26, y + 6, book.linkHoverColor);
                this.func_146279_a(I18n.func_135052_a((String)"patchoulibooks.gui.inventory_button.tooltip", (Object[])new Object[]{book.name}), mouseX, mouseY);
                continue;
            }
            this.field_146289_q.func_78276_b(text, x + 26, y + 6, book.headerColor);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.bookList.size() > 6) {
            if (this.page > 0 && this.isPointWithinBounds(this.field_146294_l / 2 - 55, this.field_146295_m / 2 + 65, 18, 10, mouseX, mouseY)) {
                --this.page;
                return;
            }
            if (this.bookList.size() > this.page * 6 + 6 && this.isPointWithinBounds(this.field_146294_l / 2 + 30, this.field_146295_m / 2 + 65, 18, 10, mouseX, mouseY)) {
                ++this.page;
                return;
            }
        }
        for (Book book : this.bookList) {
            int y;
            int x;
            int index = this.bookList.indexOf(book);
            int page = index / 6;
            int offset = index % 6;
            if (page != this.page || !this.isPointWithinBounds(x = this.field_146294_l / 2 - 62, y = this.field_146295_m / 2 - 60 + offset * 20, 110, 18, mouseX, mouseY)) continue;
            this.openBook(book);
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private void openBook(Book book) {
        BookContents contents = book.contents;
        contents.openLexiconGui(contents.getCurrentGui(), false);
    }

    private boolean isPointWithinBounds(int x, int y, int width, int height, int pointX, int pointY) {
        return pointX >= x && pointX < x + width && pointY >= y && pointY < y + height;
    }
}

