/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.mixins.patchouli;

import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.common.book.Book;

@Mixin(value={BookContents.class}, remap=false)
public abstract class BookContentsMixin {
    @Final
    @Shadow
    public Book book;

    @Shadow
    protected abstract BiFunction<Path, Path, Boolean> pred(String var1, List<ResourceLocation> var2);

    @SideOnly(value=Side.CLIENT)
    @Inject(method={"getSubtitle"}, at={@At(value="HEAD")}, cancellable=true)
    private void getSubtitle(CallbackInfoReturnable<String> cir) {
        BookContents contents = (BookContents)this;
        if (BookContentsMixin.patchouliBooks$isVersion(contents.book.version)) {
            cir.setReturnValue((Object)I18n.func_135052_a((String)"patchoulibooks.gui.lexicon.version_str", (Object[])new Object[]{contents.book.version}));
        }
    }

    @Inject(method={"findFiles"}, at={@At(value="TAIL")})
    private void globalTemplate(String dir, List<ResourceLocation> list, CallbackInfo ci) {
        ModContainer mod = this.book.owner;
        String id = mod.getModId();
        if (mod.getModId().equals("patchoulibooks") && dir.equals("templates")) {
            CraftingHelper.findFiles((ModContainer)mod, (String)String.format("assets/%s/%s", id, dir), null, this.pred(id, list), (boolean)false, (boolean)false);
        }
    }

    @ModifyArgs(method={"loadLocalizedJson"}, at=@At(value="INVOKE", target="Lvazkii/patchouli/client/book/BookContents;loadJson(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/util/ResourceLocation;)Ljava/io/InputStream;"))
    private void loadJson(Args args) {
        ResourceLocation loc = (ResourceLocation)args.get(0);
        ResourceLocation res = (ResourceLocation)args.get(1);
        if (res.func_110624_b().equals("patchoulibooks") && res.func_110623_a().split("/")[3].equals("templates")) {
            ResourceLocation redirect = new ResourceLocation("patchoulibooks", "templates/" + res.func_110623_a().split("templates/")[1]);
            args.set(0, (Object)redirect);
            args.set(1, (Object)redirect);
        }
    }

    @Unique
    private static boolean patchouliBooks$isVersion(String version) {
        String pattern = "\\d+\\.\\d+\\.\\d+";
        return version.matches(pattern);
    }
}

