/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.mixins.patchouli;

import com.google.gson.annotations.SerializedName;
import io.enderdev.patchoulibooks.unlock.Requirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.common.book.Book;

@Mixin(value={BookEntry.class}, remap=false)
public class BookEntryMixin {
    @Shadow
    Book book;
    @Shadow
    boolean locked;
    @Shadow
    boolean built;
    @Unique
    @SerializedName(value="force_locked")
    public boolean force_locked;
    @Unique
    @SerializedName(value="requirements")
    public Requirement[] patchouliBooks$requirements;
    @Unique
    public List<Requirement> patchouliBooks$realRequirements = new ArrayList<Requirement>();

    @Inject(method={"computeReadState"}, at={@At(value="HEAD")}, cancellable=true)
    private void computeReadState(CallbackInfoReturnable<EntryDisplayState> cir) {
        if (this.book.owner.getModId().equals("patchoulibooks")) {
            cir.setReturnValue((Object)EntryDisplayState.NEUTRAL);
            cir.cancel();
        }
    }

    @Inject(method={"isLocked"}, at={@At(value="HEAD")}, cancellable=true)
    private void isLocked(CallbackInfoReturnable<Boolean> cir) {
        if (this.force_locked || this.patchouliBooks$checkRequirements()) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"updateLockStatus"}, at={@At(value="HEAD")})
    private void updateLockStatus(CallbackInfo ci) {
        if (this.force_locked || this.patchouliBooks$checkRequirements()) {
            this.locked = true;
        }
    }

    @Inject(method={"build"}, at={@At(value="HEAD")})
    private void build(ResourceLocation resource, CallbackInfo ci) {
        if (!this.built && this.patchouliBooks$requirements != null && this.patchouliBooks$requirements.length != 0) {
            this.patchouliBooks$realRequirements.addAll(Arrays.asList(this.patchouliBooks$requirements));
        }
    }

    @Unique
    private boolean patchouliBooks$checkRequirements() {
        return this.patchouliBooks$requirements != null && this.patchouliBooks$requirements.length != 0 && !this.patchouliBooks$realRequirements.stream().allMatch(Requirement::unlocked);
    }
}

