/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.mixins.patchouli;

import com.google.gson.Gson;
import io.enderdev.patchoulibooks.PBConfig;
import io.enderdev.patchoulibooks.PatchouliBooks;
import io.enderdev.patchoulibooks.integration.patchouli.BookExtension;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

@Mixin(value={BookRegistry.class}, remap=false)
public class BookRegistryMixin {
    @Final
    @Shadow
    public Map<ResourceLocation, Book> books;
    @Shadow
    public Gson gson;

    @Inject(method={"loadBook"}, at={@At(value="HEAD")}, cancellable=true)
    private void loadBook(ModContainer mod, ResourceLocation res, InputStream stream, boolean external, CallbackInfo ci) throws IOException {
        PatchouliBooks.LOGGER.debug("Loading {}: [Mod]<{}> || [Book]<{}>", (Object)(external ? "EXTERNAL" : "INTERNAL"), (Object)mod.getModId(), (Object)res.func_110623_a());
        if (!mod.getModId().equals("patchoulibooks") && !external) {
            return;
        }
        if (!(Loader.isModLoaded((String)res.func_110623_a()) || PBConfig.DEBUG.enableDebug || external)) {
            PatchouliBooks.LOGGER.debug("Cancelling: [Book]<{}>, because the mod is not present.", (Object)res.func_110623_a());
            ci.cancel();
            return;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        BookRegistryMixin.patchouliBooks$copyStream(stream, buffer);
        byte[] data = buffer.toByteArray();
        BufferedReader reader1 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
        BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
        BookExtension book = (BookExtension)((Object)this.gson.fromJson((Reader)reader1, BookExtension.class));
        if (book == null) {
            PatchouliBooks.LOGGER.error("Failed to load [Book]<{}> from [Mod]<{}>", (Object)res, (Object)mod.getModId());
            ci.cancel();
            return;
        }
        if (!book.bookPlus && !mod.getModId().equals("patchoulibooks")) {
            Book pbook = (Book)this.gson.fromJson((Reader)reader2, Book.class);
            this.books.put(res, pbook);
            pbook.build(mod, res, external);
        }
        if (!book.bookDisabled && !this.books.containsKey(res)) {
            this.books.put(res, book);
            book.build(mod, res, external);
        }
        ci.cancel();
    }

    @Unique
    private static void patchouliBooks$copyStream(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }
}

