/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.mixins.patchouli;

import io.enderdev.patchoulibooks.PBConfig;
import io.enderdev.patchoulibooks.integration.patchouli.BookExtension;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.common.book.Book;

@Mixin(value={GuiBookLanding.class}, remap=false)
public abstract class GuiBookLandingMixin
extends GuiBook {
    @Shadow
    int loadedCategories;

    @Shadow
    abstract void makeErrorTooltip();

    private GuiBookLandingMixin(Book book) {
        super(book);
    }

    @Inject(method={"initGui"}, at={@At(value="INVOKE", target="Ljava/util/Collections;sort(Ljava/util/List;)V", remap=false)}, cancellable=true)
    private void renderPamphlet(CallbackInfo ci) {
        Book book = this.book;
        if (this.patchouliBooks$checkPamphlet(book)) {
            ArrayList entriesInPamphlet = new ArrayList(book.contents.entries.values());
            entriesInPamphlet.removeIf(BookEntry::shouldHide);
            Collections.sort(entriesInPamphlet);
            int i = 0;
            for (BookEntry entry : entriesInPamphlet) {
                this.field_146292_n.add(new GuiButtonEntry((GuiBook)this, this.bookLeft + 141, this.bookTop + 18 + 18 + i * 11, entry, i));
                ++i;
            }
            this.loadedCategories = i;
            ci.cancel();
        }
    }

    @Inject(method={"actionPerformed"}, at={@At(value="HEAD")})
    private void actionPerformed(GuiButton button, CallbackInfo ci) {
        if (button instanceof GuiButtonEntry) {
            this.displayLexiconGui((GuiBook)new GuiBookEntry(this.book, ((GuiButtonEntry)button).getEntry()), true);
        }
    }

    @Inject(method={"drawForegroundElements"}, at={@At(value="INVOKE", target="Lvazkii/patchouli/client/book/gui/GuiBookLanding;drawCenteredStringNoShadow(Ljava/lang/String;III)V")}, cancellable=true)
    private void drawForegroundElements(int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        Book book = this.book;
        if (this.patchouliBooks$checkPamphlet(book)) {
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchoulibooks.gui.lexicon.pamphlet", (Object[])new Object[0]), 199, 18, book.headerColor);
            int topSeparator = 30;
            int bottomSeparator = topSeparator + 8 + 11 * this.loadedCategories;
            this.patchouliBooks$drawHeader();
            GuiBookLandingMixin.drawSeparator((Book)book, (int)141, (int)topSeparator);
            if (this.loadedCategories <= 12) {
                GuiBookLandingMixin.drawSeparator((Book)book, (int)141, (int)bottomSeparator);
            }
            if (book.contents.isErrored()) {
                int x = 199;
                int y = bottomSeparator + 12;
                this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), x, y, 0xFF0000);
                this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error_hover", (Object[])new Object[0]), x, y + 10, 0x777777);
                if (this.isMouseInRelativeRange(mouseX, mouseY, x -= 58, y -= 4, 116, 20)) {
                    this.makeErrorTooltip();
                }
            }
            ci.cancel();
        }
    }

    @Unique
    private void patchouliBooks$drawHeader() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBookLandingMixin.drawFromTexture((Book)this.book, (int)-8, (int)12, (int)0, (int)180, (int)140, (int)31);
        int color = this.book.nameplateColor;
        boolean unicode = this.field_146289_q.func_82883_a();
        String displayName = this.book.getBookItem().func_82833_r();
        this.field_146289_q.func_78276_b(displayName.substring(0, displayName.length() - 6), 13, 16, color);
        if (!this.book.useBlockyFont) {
            this.field_146289_q.func_78264_a(true);
        }
        this.field_146289_q.func_78276_b(this.book.contents.getSubtitle(), 24, 24, color);
        this.field_146289_q.func_78264_a(unicode);
    }

    @Unique
    private boolean patchouliBooks$checkPamphlet(Book book) {
        return book.contents.categories.size() <= 1 && book.contents.entries.size() <= 14 && (book instanceof BookExtension && ((BookExtension)book).isPamphlet || PBConfig.GENERAL.enablePamphlets);
    }
}

