/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.pages;

import io.enderdev.patchoulibooks.pages.RenderObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.book.Book;

public abstract class PageBase
extends BookPage {
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int PAGE_WIDTH = 116;
    public static final int PAGE_HEIGHT = 156;
    public static final int TOP_PADDING = 18;
    public static final int LEFT_PAGE_X = 15;
    public static final int RIGHT_PAGE_X = 141;
    public static final int TEXT_LINE_HEIGHT = 9;
    public static final int MAX_BOOKMARKS = 10;
    public static final int ITEM_WIDTH = 16;
    public static final int ITEM_HEIGHT = 16;
    public static final int DIST_HEADER_SEP = 10;
    public static final int DIST_SEP_TEXT = 12;
    public static final int PAGE_CENTER_HORIZONTAL = 58;
    public static final int PAGE_CENTER_VERTICAL = 75;
    protected static final Map<String, ResourceLocation> TEXTURES = new HashMap<String, ResourceLocation>(){
        {
            this.put("hourglass", new ResourceLocation("patchoulibooks", "textures/templates/pedestal_crafting/hourglass.png"));
            this.put("pillar_middle", new ResourceLocation("patchoulibooks", "textures/templates/pedestal_crafting/pedestal_core.png"));
            this.put("pillar", new ResourceLocation("patchoulibooks", "textures/templates/pedestal_crafting/pedestal.png"));
        }
    };

    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
    }

    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
    }

    public abstract void render(int var1, int var2, float var3);

    public abstract void mouseClicked(int var1, int var2, int var3);

    protected void drawTitle(String title) {
        boolean renderedSmol = false;
        String smolText = "";
        if (this.mc.field_71474_y.field_82882_x) {
            smolText = this.pageNum == 0 ? this.parent.getEntry().getResource().toString() : I18n.func_135052_a((String)"patchoulibooks.gui.lexicon.page_type", (Object[])new Object[]{this.type});
        } else if (this.entry.isExtension()) {
            String name = this.entry.getTrueProvider().getOwnerName();
            smolText = I18n.func_135052_a((String)"patchouli.gui.lexicon.added_by", (Object[])new Object[]{name});
        }
        if (!smolText.isEmpty()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            this.parent.drawCenteredStringNoShadow(smolText, 116, 5, this.book.headerColor);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            renderedSmol = true;
        }
        this.drawHeading(title, renderedSmol ? -6 : -3, true, renderedSmol ? 3 : 0);
    }

    protected void drawHeading(String title, int posY, boolean separator) {
        this.drawHeading(title, posY, separator, 0);
    }

    protected void drawHeading(String title, int posY, boolean separator, int spacing) {
        float shrinkFactor = 1.0f;
        int distanceToPageEdge = 10;
        if (this.mc.field_71466_p.func_78256_a(title) > 116 - distanceToPageEdge) {
            shrinkFactor = (float)(116 - distanceToPageEdge) / (float)this.mc.field_71466_p.func_78256_a(title);
        }
        GlStateManager.func_179152_a((float)shrinkFactor, (float)shrinkFactor, (float)1.0f);
        this.parent.drawCenteredStringNoShadow(title, (int)(58.0f / shrinkFactor), (int)((float)posY / shrinkFactor), this.book.headerColor);
        GlStateManager.func_179152_a((float)(1.0f / shrinkFactor), (float)(1.0f / shrinkFactor), (float)1.0f);
        if (separator) {
            GuiBook.drawSeparator((Book)this.book, (int)0, (int)(posY + 10 + spacing));
        }
    }

    protected void drawItem(boolean drawFrame, Object obj, int posX, int posY, int mouseX, int mouseY) {
        if (obj instanceof ItemStack) {
            this.parent.renderItemStack(posX, posY, mouseX, mouseY, (ItemStack)obj);
        } else if (obj instanceof Ingredient) {
            this.parent.renderIngredient(posX, posY, mouseX, mouseY, (Ingredient)obj);
        } else if (obj instanceof RenderObject) {
            ((RenderObject)obj).render(this.parent, posX, posY, mouseX, mouseY);
        }
        if (drawFrame) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(this.book.craftingResource);
            Gui.func_146110_a((int)(posX - 4), (int)(posY - 4), (float)83.0f, (float)71.0f, (int)24, (int)24, (float)128.0f, (float)128.0f);
        }
    }

    protected void drawTexture(ResourceLocation texture, int posX, int posY, int posU, int posV, int width, int height, int textureWidth, int textureHeight) {
        this.mc.field_71446_o.func_110577_a(texture);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)posX, (int)posY, (float)posU, (float)posV, (int)width, (int)height, (float)textureWidth, (float)textureHeight);
    }

    protected void drawFullTexture(ResourceLocation texture, int posX, int posY, int width, int height) {
        this.drawTexture(texture, posX, posY, 0, 0, width, height, width, height);
    }

    protected void drawHighlightItem(Object item, int posY, int mouseX, int mouseY) {
        int w = 66;
        int h = 26;
        this.drawTexture(this.book.craftingResource, this.centerHorizontal(w), posY, 0, 128 - h, w, h, 128, 128);
        this.drawItem(false, item, this.centerHorizontal(16), posY + 5, mouseX, mouseY);
    }

    protected void drawCraftingRecipe(IRecipe recipe, int recipeY, int mouseX, int mouseY) {
        if (recipe == null) {
            return;
        }
        int recipeX = 9;
        this.mc.field_71446_o.func_110577_a(this.book.craftingResource);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)(recipeX - 2), (int)(recipeY - 2), (float)0.0f, (float)0.0f, (int)100, (int)62, (float)128.0f, (float)128.0f);
        boolean shaped = recipe instanceof IShapedRecipe;
        if (!shaped) {
            int iconX = recipeX + 62;
            int iconY = recipeY + 2;
            Gui.func_146110_a((int)iconX, (int)iconY, (float)0.0f, (float)64.0f, (int)11, (int)11, (float)128.0f, (float)128.0f);
            if (this.parent.isMouseInRelativeRange(mouseX, mouseY, iconX, iconY, 11, 11)) {
                this.parent.setTooltip(new String[]{I18n.func_135052_a((String)"patchouli.gui.lexicon.shapeless", (Object[])new Object[0])});
            }
        }
        this.parent.renderItemStack(recipeX + 79, recipeY + 22, mouseX, mouseY, recipe.func_77571_b());
        NonNullList ingredients = recipe.func_192400_c();
        int wrap = 3;
        if (shaped) {
            wrap = ((IShapedRecipe)recipe).getRecipeWidth();
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            this.parent.renderIngredient(recipeX + i % wrap * 19 + 3, recipeY + i / wrap * 19 + 3, mouseX, mouseY, (Ingredient)ingredients.get(i));
        }
    }

    protected int centerHorizontal(int width) {
        return 58 - width / 2;
    }

    protected int centerVertical(int height) {
        return 75 - height / 2;
    }
}

