/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.pages;

import com.google.gson.annotations.SerializedName;
import io.enderdev.patchoulibooks.PatchouliBooks;
import io.enderdev.patchoulibooks.pages.PageBase;
import io.enderdev.patchoulibooks.pages.PageDecorator;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

@PageDecorator(value="crafting+")
public class PageCrafting
extends PageBase {
    String title;
    @SerializedName(value="recipe")
    String recipeRaw;
    String text;
    String title2;
    @SerializedName(value="recipe2")
    String recipe2Raw;
    String text2;
    @SerializedName(value="link_recipe")
    boolean linkRecipe = true;
    protected transient IRecipe recipe1;
    protected transient IRecipe recipe2;
    protected transient BookTextRenderer textRenderer1;
    protected transient BookTextRenderer textRenderer2;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.recipe1 = this.loadRecipe(entry, this.recipeRaw);
        this.recipe2 = this.loadRecipe(entry, this.recipe2Raw);
        if (this.recipe1 != null && this.recipe1.equals(this.recipe2)) {
            if (this.text != null && !this.text.isEmpty()) {
                this.recipe1 = null;
            } else if (this.text2 != null && !this.text2.isEmpty()) {
                this.recipe2 = null;
            } else {
                this.recipe1 = null;
                this.recipe2 = null;
            }
        }
        if (this.title == null && this.recipe1 == null && pageNum == 0) {
            this.title = entry.getName();
        }
        this.text = this.text == null ? "" : this.text;
        String string = this.text2 = this.text2 == null ? "" : this.text2;
        if (!this.text.isEmpty() && this.text2.isEmpty()) {
            this.text2 = this.text;
        }
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        this.textRenderer1 = new BookTextRenderer((GuiBook)parent, this.text, 0, this.title != null && !this.title.isEmpty() || this.recipeRaw != null && this.pageNum != 0 ? 12 : -6);
        this.textRenderer2 = new BookTextRenderer((GuiBook)parent, this.text2, 0, 75 + (this.title2 != null && !this.title2.isEmpty() || this.recipe2Raw != null ? 12 : 0));
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        if (this.title != null) {
            if (!this.title.isEmpty()) {
                this.drawTitle(this.title);
            }
        } else if (this.recipeRaw != null) {
            this.drawTitle(this.getRecipeOutput(this.recipe1).func_82833_r());
        }
        int recipeY = 12;
        if (this.recipe1 != null) {
            this.drawCraftingRecipe(this.recipe1, recipeY, mouseX, mouseY);
        } else {
            this.textRenderer1.render(mouseX, mouseY);
        }
        if (this.title2 != null) {
            if (!this.title2.isEmpty()) {
                this.drawHeading(this.title2, 73, true);
            }
        } else if (this.recipe2Raw != null) {
            this.drawHeading(this.getRecipeOutput(this.recipe2).func_82833_r(), 73, true);
        }
        if (this.recipe2Raw != null) {
            this.drawCraftingRecipe(this.recipe2, recipeY + 76, mouseX, mouseY);
        } else {
            this.textRenderer2.render(mouseX, mouseY);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.textRenderer1 != null) {
            this.textRenderer1.click(mouseX, mouseY, mouseButton);
        }
        if (this.textRenderer2 != null) {
            this.textRenderer2.click(mouseX, mouseY, mouseButton);
        }
    }

    protected IRecipe loadRecipe(BookEntry entry, String loc) {
        if (loc == null) {
            return null;
        }
        ResourceLocation res = new ResourceLocation(loc);
        IRecipe tempRecipe = CraftingManager.func_193373_a((ResourceLocation)res);
        if (tempRecipe == null) {
            String raw = loc.split(":")[0] + ":" + loc.split(":")[1];
            int meta = loc.split(":").length == 3 ? Integer.parseInt(loc.split(":")[2]) : 0;
            Item item = Item.func_111206_d((String)raw);
            if (item != null) {
                ItemStack stack = new ItemStack(item, 1, meta);
                ResourceLocation origin = CraftingManager.field_193380_a.func_148742_b().stream().filter(resourceLocation -> ((IRecipe)Objects.requireNonNull(CraftingManager.field_193380_a.func_82594_a(resourceLocation))).func_77571_b().func_77969_a(stack)).findFirst().orElse(null);
                if (origin != null) {
                    tempRecipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)origin);
                } else {
                    PatchouliBooks.LOGGER.debug("Could not find a recipe for item: {}", (Object)loc);
                }
            }
        }
        if (tempRecipe != null && this.linkRecipe) {
            entry.addRelevantStack(tempRecipe.func_77571_b(), this.pageNum);
        }
        return tempRecipe;
    }

    protected ItemStack getRecipeOutput(IRecipe recipe) {
        return recipe == null ? ItemStack.field_190927_a : recipe.func_77571_b();
    }
}

