/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.pages;

import com.google.gson.annotations.SerializedName;
import io.enderdev.patchoulibooks.pages.PageBase;
import io.enderdev.patchoulibooks.pages.PageDecorator;
import io.enderdev.patchoulibooks.pages.RenderObject;
import net.minecraft.client.gui.GuiButton;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

@PageDecorator(value="link+")
public class PageLink
extends PageBase {
    String title;
    String text;
    String url;
    String link;
    String icon;
    @SerializedName(value="link_text")
    String linkText;
    @SerializedName(value="button_text")
    String buttonText;
    transient GuiButton linkButton;
    transient BookTextRenderer textRenderer;
    transient RenderObject iconObj;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        RenderObject renderObject = this.iconObj = this.icon != null ? new RenderObject(this.icon) : null;
        if (this.url == null) {
            this.url = this.link;
        }
        if (this.linkText == null && this.buttonText == null) {
            this.linkText = "Open Link";
        }
        if (this.buttonText != null) {
            this.linkText = this.buttonText;
        }
        if (this.title == null) {
            this.title = pageNum == 0 ? entry.getName() : "";
        }
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        int start = this.iconObj != null ? (this.title.isEmpty() ? 21 : 39) : (this.title.isEmpty() ? -6 : 12);
        this.textRenderer = new BookTextRenderer((GuiBook)parent, this.text, 0, start);
        this.linkButton = new GuiButton(0, 8, 121, 100, 20, this.linkText);
        this.addButton(this.linkButton);
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        if (!this.title.isEmpty()) {
            this.drawTitle(this.title);
        }
        if (this.iconObj != null) {
            this.drawHighlightItem(this.iconObj, !this.title.isEmpty() ? 12 : -6, mouseX, mouseY);
        }
        this.textRenderer.render(mouseX, mouseY);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    protected void onButtonClicked(GuiButton button) {
        super.onButtonClicked(button);
        if (button == this.linkButton) {
            GuiBook.openWebLink((String)this.url);
        }
    }
}

