/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.pages;

import com.google.gson.annotations.SerializedName;
import io.enderdev.patchoulibooks.PatchouliBooks;
import io.enderdev.patchoulibooks.pages.PageBase;
import io.enderdev.patchoulibooks.pages.PageDecorator;
import io.enderdev.patchoulibooks.util.MathUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.util.ItemStackUtil;

@PageDecorator(value="pillar")
public class PagePillar
extends PageBase {
    String title = "";
    @SerializedName(value="output")
    String output;
    @SerializedName(value="center")
    String middle;
    @SerializedName(value="inputs")
    String[] inputs;
    @SerializedName(value="time")
    int time = 0;
    @SerializedName(value="link_recipe")
    boolean linkRecipe = true;
    transient ItemStack itemOutput;
    transient Ingredient itemMiddle;
    transient Ingredient[] itemInputs;
    transient BookTextRenderer textRenderer;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.itemOutput = ItemStackUtil.loadStackFromString((String)this.output);
        this.itemMiddle = ItemStackUtil.loadIngredientFromString((String)this.middle);
        this.itemInputs = new Ingredient[Math.min(this.inputs.length, 32)];
        for (int i = 0; i < this.itemInputs.length; ++i) {
            this.itemInputs[i] = ItemStackUtil.loadIngredientFromString((String)this.inputs[i]);
        }
        if (this.linkRecipe) {
            entry.addRelevantStack(this.itemOutput, pageNum);
        }
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        this.textRenderer = new BookTextRenderer((GuiBook)parent, String.format("$(l)%.1fs$()", (double)this.time / 20.0), 18, 20);
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        this.drawTitle(!this.title.isEmpty() ? this.title : this.itemOutput.func_82833_r());
        this.drawItem(true, this.itemOutput, 50, 16, mouseX, mouseY);
        this.drawItemWithPillar(this.itemMiddle, true, 50, 78, mouseX, mouseY);
        if (this.time > 0) {
            this.drawFullTexture((ResourceLocation)TEXTURES.get("hourglass"), 0, 16, 16, 16);
            this.textRenderer.render(mouseX, mouseY);
        }
        List<MathUtil.Point> points = MathUtil.arrangeOnCircle(this.itemInputs.length, 40.0, 50.0, 78.0);
        for (int i = 0; i < this.itemInputs.length; ++i) {
            Ingredient ingr = this.itemInputs[i];
            if (ingr == null) {
                PatchouliBooks.LOGGER.debug("Ingredient is null at index {} in entry {}", (Object)i, (Object)this.entry.getResource().func_110623_a());
                continue;
            }
            int x = (int)points.get(i).getX();
            int y = (int)points.get(i).getY();
            this.drawItemWithPillar(ingr, false, x, y, mouseX, mouseY);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.textRenderer != null) {
            this.textRenderer.click(mouseX, mouseY, mouseButton);
        }
    }

    private void drawItemWithPillar(Object item, boolean core, int posX, int posY, int mouseX, int mouseY) {
        this.drawItem(false, item, posX, posY, mouseX, mouseY);
        this.drawFullTexture(core ? (ResourceLocation)TEXTURES.get("pillar_middle") : (ResourceLocation)TEXTURES.get("pillar"), posX, posY + 12, 16, 16);
    }
}

