/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.pages;

import com.google.gson.annotations.SerializedName;
import io.enderdev.patchoulibooks.pages.PageBase;
import io.enderdev.patchoulibooks.pages.PageDecorator;
import io.enderdev.patchoulibooks.pages.RenderObject;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

@PageDecorator(value="spotlight+")
public class PageSpotlight
extends PageBase {
    @SerializedName(value="item")
    String objRaw;
    String title;
    String text;
    transient BookTextRenderer textRenderer;
    @SerializedName(value="link_recipe")
    boolean linkRecipe = true;
    transient RenderObject obj;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.obj = new RenderObject(this.objRaw);
        if (this.obj.isItem() && this.linkRecipe) {
            entry.addRelevantStack(this.obj.getItemStack(), pageNum);
        }
        if (this.title == null) {
            String string = this.title = this.obj.isItem() ? this.obj.getItemStack().func_82833_r() : "";
            if (this.title.isEmpty() && pageNum == 0) {
                this.title = entry.getName();
            }
        }
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        this.textRenderer = new BookTextRenderer((GuiBook)parent, this.text, 0, !this.title.isEmpty() ? 39 : 21);
    }

    @Override
    public void render(int mouseX, int mouseY, float pticks) {
        if (!this.title.isEmpty()) {
            this.drawTitle(this.title);
        }
        this.drawHighlightItem(this.obj, !this.title.isEmpty() ? 12 : -6, mouseX, mouseY);
        this.textRenderer.render(mouseX, mouseY);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.textRenderer != null) {
            this.textRenderer.click(mouseX, mouseY, mouseButton);
        }
    }
}

