/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.pages;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.common.util.ItemStackUtil;

public class RenderObject {
    private final IconType type;
    private final ItemStack stack;
    private final Ingredient ingredient;
    private final ResourceLocation res;

    public RenderObject(String str) {
        if (str.endsWith(".png")) {
            this.type = IconType.RESOURCE;
            this.stack = null;
            this.ingredient = null;
            this.res = new ResourceLocation(str);
        } else {
            this.ingredient = ItemStackUtil.loadIngredientFromString((String)str);
            this.stack = ItemStackUtil.loadStackFromString((String)str);
            this.res = null;
            this.type = this.stack != null && !this.stack.func_190926_b() ? IconType.STACK : IconType.INGREDIENT;
        }
    }

    public RenderObject(ItemStack stack) {
        this.type = IconType.STACK;
        this.stack = stack;
        this.ingredient = null;
        this.res = null;
    }

    public RenderObject(ResourceLocation res) {
        this.type = IconType.RESOURCE;
        this.stack = null;
        this.ingredient = null;
        this.res = res;
    }

    public RenderObject(Ingredient ingredient) {
        this.type = IconType.INGREDIENT;
        this.stack = null;
        this.ingredient = ingredient;
        this.res = null;
    }

    public void render(GuiBookEntry parent, int posX, int posY, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isItem()) {
            parent.renderItemStack(posX, posY, mouseX, mouseY, this.getItemStack());
        } else if (this.isIngredient()) {
            parent.renderIngredient(posX, posY, mouseX, mouseY, this.getIngredient());
        } else if (this.isTexture()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71446_o.func_110577_a(this.getResourceLocation());
            Gui.func_152125_a((int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
    }

    public boolean isTexture() {
        return this.type == IconType.RESOURCE;
    }

    public boolean isItem() {
        return this.type == IconType.STACK;
    }

    public boolean isIngredient() {
        return this.type == IconType.INGREDIENT;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ResourceLocation getResourceLocation() {
        return this.res;
    }

    private static enum IconType {
        STACK,
        RESOURCE,
        INGREDIENT;

    }
}

