/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.recipes;

import io.enderdev.patchoulibooks.PBConfig;
import io.enderdev.patchoulibooks.PatchouliBooks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class RecipeRegister {
    private final List<ResourceLocation> RECIPES = new ArrayList<ResourceLocation>();

    public RecipeRegister() {
        this.addBookRecipe("gendustry", "gene_sample_blank");
        this.addBookRecipe("thermallogistics", "crafter");
        this.addBookRecipe("moarboats", "oars");
        this.addBookRecipe("pressure", "pipe");
    }

    @SubscribeEvent
    public void init(RegistryEvent.Register<IRecipe> event) {
        if (!PBConfig.GENERAL.enableRecipes) {
            return;
        }
        this.RECIPES.forEach(resourceLocation -> {
            String mod_id = resourceLocation.func_110624_b();
            if (Loader.isModLoaded((String)mod_id)) {
                Item input = Item.func_111206_d((String)resourceLocation.toString());
                if (input == null) {
                    PatchouliBooks.LOGGER.error("Unable to find item at {}", (Object)resourceLocation.toString());
                    return;
                }
                ResourceLocation id = new ResourceLocation("patchoulibooks", mod_id);
                ShapelessOreRecipe recipe = this.generateRecipe(id, input);
                if (recipe == null) {
                    PatchouliBooks.LOGGER.error("Unable to generate recipe for {}", (Object)id);
                    return;
                }
                event.getRegistry().register(recipe.setRegistryName(id));
            }
        });
    }

    private ShapelessOreRecipe generateRecipe(ResourceLocation id, Item input) {
        ItemStack book = BookRegistry.INSTANCE.books.values().stream().filter(b -> b.resourceLoc.func_110623_a().equals(id.func_110623_a())).map(Book::getBookItem).findFirst().orElse(ItemStack.field_190927_a);
        if (book.func_190926_b()) {
            PatchouliBooks.LOGGER.warn("Book not found for mod id: {}", (Object)id.func_110623_a());
            return null;
        }
        return new ShapelessOreRecipe(id, book, new Object[]{Items.field_151122_aG, Ingredient.func_193367_a((Item)input)});
    }

    private void addBookRecipe(String mod_id, String item_name) {
        this.RECIPES.add(new ResourceLocation(mod_id, item_name));
    }
}

