/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.unlock;

import io.enderdev.patchoulibooks.unlock.UnlockTypes;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.common.Loader;

public class Requirement {
    private final String type;
    private final String trigger;
    transient boolean fullfilled = false;

    public Requirement(String type, String trigger) {
        this.type = type;
        this.trigger = trigger;
    }

    public UnlockTypes getType() {
        return UnlockTypes.fromString(this.type);
    }

    public String getTrigger() {
        return this.trigger;
    }

    public boolean unlocked() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        switch (this.getType()) {
            case GAMEMODE: {
                return this.checkGamemode((EntityPlayer)player);
            }
            case DIMENSION: {
                return this.checkDimension((EntityPlayer)player);
            }
            case GAMESTAGE: {
                return this.checkGamestage((EntityPlayer)player);
            }
            case GAMERULE: {
                return this.checkGamerule((EntityPlayer)player);
            }
        }
        return false;
    }

    private boolean checkGamemode(@Nonnull EntityPlayer player) {
        boolean creative = player.func_184812_l_() && this.getTrigger().toLowerCase(Locale.ROOT).equals("creative");
        boolean spectator = player.func_175149_v() && this.getTrigger().toLowerCase(Locale.ROOT).equals("spectator");
        boolean survival = !player.func_184812_l_() && !player.func_175149_v() && (this.getTrigger().toLowerCase(Locale.ROOT).equals("survival") || this.getTrigger().toLowerCase(Locale.ROOT).equals("adventure"));
        this.fullfilled = creative || survival || spectator;
        return this.fullfilled;
    }

    private boolean checkDimension(@Nonnull EntityPlayer player) {
        String currentDimension = player.field_70170_p.field_73011_w.func_186058_p().func_186065_b().toLowerCase(Locale.ROOT);
        this.fullfilled = currentDimension.equals(this.getTrigger().toLowerCase(Locale.ROOT));
        return this.fullfilled;
    }

    private boolean checkGamestage(@Nonnull EntityPlayer player) {
        if (!Loader.isModLoaded((String)"gamestages")) {
            return true;
        }
        this.fullfilled = GameStageHelper.hasStage((EntityPlayer)player, (String)this.getTrigger());
        return this.fullfilled;
    }

    private boolean checkGamerule(@Nonnull EntityPlayer player) {
        GameRules rules = player.field_70170_p.func_82736_K();
        return rules.func_82765_e(this.getTrigger()) && rules.func_82766_b(this.getTrigger());
    }
}

