/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.patchoulibooks.util;

import java.util.ArrayList;
import java.util.List;

public class MathUtil {
    private MathUtil() {
    }

    public static List<Point> arrangeOnCircle(int numObjects, double radius, double centerX, double centerY) {
        ArrayList<Point> points = new ArrayList<Point>();
        double angleIncrement = Math.PI * 2 / (double)numObjects;
        for (int i = 0; i < numObjects; ++i) {
            double angle = (double)i * angleIncrement;
            double x = centerX + radius * Math.cos(angle);
            double y = centerY + radius * Math.sin(angle);
            points.add(new Point(x, y));
        }
        return points;
    }

    public static class Point {
        private final double x;
        private final double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

