package org.codeberg.zenxarch.damagevignette.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;
import org.codeberg.zenxarch.damagevignette.client.mixin.InGameHudAccessor;
import org.codeberg.zenxarch.damagevignette.client.utils.TickingValue;

public class DamageVignette {

  private TickingValue strength = new TickingValue(0.0f, 0.5f);

  public void render(class_332 context, class_9779 tickCounter) {
    var newStrength = getVignetteStrength();
    strength.tick(tickCounter, newStrength);
    if (strength.getValue() <= 0.0f) return;
    var color = getVignetteColor(strength.getValue());
    renderOverlay(
        context,
        InGameHudAccessor.zenxarch$getVignetteTexture(),
        color[0],
        color[1],
        color[2],
        color[3]);
  }

  private void renderOverlay(
      class_332 context, class_2960 texture, float a, float r, float g, float b) {
    RenderSystem.disableDepthTest();
    RenderSystem.depthMask(false);
    RenderSystem.enableBlend();
    context.method_51422(r, g, b, a);
    context.method_25291(
        texture,
        0,
        0,
        -90,
        0.0F,
        0.0F,
        context.method_51421(),
        context.method_51443(),
        context.method_51421(),
        context.method_51443());
    RenderSystem.disableBlend();
    RenderSystem.depthMask(true);
    RenderSystem.enableDepthTest();
    context.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
  }

  private float[] getVignetteColor(float strength) {
    var value = class_3532.method_16439(strength, 0.0f, 0.65f);

    return new float[] {value, 1.0f, 0.0f, 0.0f};
  }

  private float getVignetteStrength() {
    var player = class_310.method_1551().field_1724;
    return (player.method_6063() - player.method_6032()) / player.method_6063();
  }
}
