package org.codeberg.zenxarch.damagevignette.client;

import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_10799;
import net.minecraft.class_12079;
import net.minecraft.class_12079.class_10726;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_765;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.codeberg.zenxarch.damagevignette.DamageVignetteMod;
import org.codeberg.zenxarch.damagevignette.client.utils.TickingValue;

public class DamageVignette implements HudElement {

  private TickingValue strength = new TickingValue(0.0f, 0.5f);
  private static final class_10726 vignetteAsset =
      new class_12079.class_10726(DamageVignetteMod.id("vignette"));

  @Override
  public void render(class_332 context, class_9779 tickCounter) {
    var newStrength = getVignetteStrength();
    strength.tick(tickCounter, newStrength);
    if (!doesGamemodeHaveHearts()) return;
    if (strength.getValue() <= 0.0f) return;
    var color = getVignetteColor(strength.getValue());
    context.method_25291(
        class_10799.field_56883,
        vignetteAsset.comp_3627(),
        0,
        0,
        0.0F,
        0.0F,
        context.method_51421(),
        context.method_51443(),
        context.method_51421(),
        context.method_51443(),
        color);
  }

  private int getVignetteColor(float strength) {
    var value = class_3532.method_16439(strength, 0.0f, 0.65f);

    return class_9848.method_61318(value, 1.0f, 0.0f, 0.0f);
  }

  private float screenBrightness() {
    var camera = class_310.method_1551().method_1560();
    if (camera == null) return 1.0f;
    var cameraPos = class_2338.method_49637(camera.method_23317(), camera.method_23320(), camera.method_23321());
    var world = camera.method_73183();
    return class_765.method_23284(
        world.method_8597(), world.method_22339(cameraPos));
  }

  private boolean doesGamemodeHaveHearts() {
    var player = class_310.method_1551().field_1724;
    if (player == null) return false;
    var mode = player.method_68876();
    if (mode == null) return false;
    return mode.method_8388();
  }

  private float getVignetteStrength() {
    var player = class_310.method_1551().field_1724;
    if (player == null) return 0.0f;
    var brightnessDelta = class_3532.method_16439(screenBrightness(), 0.25f, 0f);
    var health = (player.method_6063() - player.method_6032()) / player.method_6063();
    return class_3532.method_16439(brightnessDelta, health, 0.0f);
  }
}
