package org.codeberg.zenxarch.damagevignette.client.utils;

import net.minecraft.class_9779;

public class TickingValue {
  private float value;
  private final float maxChangePerTick;

  public TickingValue(float value, float maxChangePerTick) {
    this.value = value;
    this.maxChangePerTick = maxChangePerTick;
  }

  public void tick(class_9779 counter, float newValue) {
    var change = newValue - this.value;
    change = Math.signum(change) * Math.min(this.maxChangePerTick, Math.abs(change));
    this.value += change * Math.min(counter.method_60636(), 1f);
  }

  public float getValue() {
    return this.value;
  }
}
