/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.simplepaperdoll.module;

import dev.nymnux.simplepaperdoll.config.CfgPaperDoll;
import dev.nymnux.simplepaperdoll.config.ModConfig;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class SimplePaperDoll {
    private static final double YAW_BASE = 180.0;
    private static final double MAX_PITCH_LIMIT = 90.0;
    private static final float PI = (float)Math.PI;
    private static double yaw = 180.0;
    private static double lastRealtimeYaw = 180.0;
    private static boolean yawChanged = false;
    private static double yawSmooth = 180.0;
    private static double pitch = 0.0;

    private static void tickRotationRestore() {
        CfgPaperDoll config = ModConfig.getInstance().cfgPaperDoll;
        if (!yawChanged) {
            yawSmooth = yaw;
            double dYaw = (1.0 + Math.sin(1.5707963267948966 * (Math.abs(180.0 - yaw) / config.rotateLimitHDeg))) * config.yawRestoreSpeed;
            if (yaw > 180.0) {
                yaw = Math.max(yaw - dYaw, 180.0);
            } else if (yaw < 180.0) {
                yaw = Math.min(yaw + dYaw, 180.0);
            }
        }
    }

    private static void updateRotation(double realtimeYaw, double realtimePitch) {
        CfgPaperDoll config = ModConfig.getInstance().cfgPaperDoll;
        double yawLimit = config.rotateLimitHDeg;
        double pitchLimit = config.rotateLimitVDeg;
        boolean bl = yawChanged = Math.abs(lastRealtimeYaw - realtimeYaw) > config.yawChangeEpsilonDeg;
        if (yawChanged) {
            double dYaw = SimplePaperDoll.relativeAngleDiffDeg(realtimeYaw, lastRealtimeYaw) * config.yawChangeSpeed;
            yaw += dYaw;
            yawSmooth = yaw = class_3532.method_15350((double)yaw, (double)(180.0 - yawLimit), (double)(180.0 + yawLimit));
        }
        lastRealtimeYaw = realtimeYaw;
        if (config.mapPitchLimit) {
            realtimePitch *= pitchLimit / 90.0;
        }
        pitch = class_3532.method_15350((double)realtimePitch, (double)(-pitchLimit), (double)pitchLimit);
    }

    public void onHudRender(class_332 drawContext, float tickDelta) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        CfgPaperDoll config = ModConfig.getInstance().cfgPaperDoll;
        if (!config.enable) {
            return;
        }
        double realtimeYaw = SimplePaperDoll.clampYaw(client.field_1724.method_36454());
        double realtimePitch = SimplePaperDoll.clampPitch(client.field_1724.method_36455());
        SimplePaperDoll.updateRotation(realtimeYaw, realtimePitch);
        int scaledWidth = client.method_22683().method_4486();
        int scaledHeight = client.method_22683().method_4502();
        int x = (int)((double)scaledWidth * config.xPercent);
        int y = (int)((double)scaledHeight * config.yPercent);
        int dx = config.dx;
        int dy = config.dy;
        SimplePaperDoll.drawPaperDoll(drawContext, x, y, dx, dy, config.scale, config.cameraRotationHDeg, config.cameraRotationVDeg, tickDelta);
        if (!config.showBox) {
            return;
        }
        SimplePaperDoll.drawOutlineQuad(drawContext, x - dx, y - dy, dx * 2, dy * 2, -1);
    }

    private static void drawPaperDoll(class_332 drawContext, int x, int y, int dx, int dy, double scale, double rotateHDeg, double rotateVDeg, float tickDelta) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        int x1 = x - dx;
        int y1 = y - dy;
        int x2 = x + dx;
        int y2 = y + dy;
        class_746 player = client.field_1724;
        float rotateHRad = (float)Math.toRadians(rotateHDeg);
        float rotateVRad = (float)Math.toRadians(rotateVDeg);
        Quaternionf rotation = new Quaternionf().rotateXYZ(rotateVRad, -rotateHRad, (float)Math.PI);
        float yaw_ = player.method_36454();
        float pitch_ = player.method_36455();
        float lastPitch_ = player.field_6004;
        float lastHeadYaw_ = player.field_6259;
        float headYaw_ = player.field_6241;
        float bodyYaw_ = player.field_6283;
        float lastBodyYaw_ = player.field_6220;
        float yawI = (float)class_3532.method_16436((double)tickDelta, (double)yawSmooth, (double)yaw);
        player.method_36456(yawI);
        player.method_36457((float)pitch);
        player.field_6004 = (float)pitch;
        player.field_6259 = yawI;
        player.field_6241 = yawI;
        player.field_6283 = 180.0f;
        player.field_6220 = 180.0f;
        Vector3f translation = new Vector3f(0.0f, player.method_17682() / 2.0f + 0.0625f, 0.0f);
        class_898 dispatcher = client.method_1561();
        class_897 renderer = dispatcher.method_3953((class_1297)player);
        class_10017 renderState = renderer.method_62425((class_1297)player, tickDelta);
        renderState.field_58169 = null;
        drawContext.method_70856(renderState, (float)scale, translation, rotation, null, x1, y1, x2, y2);
        player.method_36456(yaw_);
        player.method_36457(pitch_);
        player.field_6004 = lastPitch_;
        player.field_6259 = lastHeadYaw_;
        player.field_6241 = headYaw_;
        player.field_6283 = bodyYaw_;
        player.field_6220 = lastBodyYaw_;
    }

    public void onClientTickStart(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        CfgPaperDoll config = ModConfig.getInstance().cfgPaperDoll;
        if (!config.enable) {
            return;
        }
        SimplePaperDoll.tickRotationRestore();
    }

    private static double relativeAngleDiffDeg(double degTo, double degFrom) {
        return ((degTo - degFrom) % 360.0 + 540.0) % 360.0 - 180.0;
    }

    private static double clampYaw(double yaw) {
        if ((yaw %= 360.0) < 0.0) {
            yaw += 360.0;
        }
        return yaw;
    }

    private static double clampPitch(double pitch) {
        pitch = Math.max(-90.0, Math.min(90.0, pitch));
        return pitch;
    }

    private static void drawOutlineQuad(class_332 context, int x, int y, int width, int height, int color) {
        SimplePaperDoll.fill(context, x, y, width, 1, color);
        SimplePaperDoll.fill(context, x + width - 1, y, 1, height, color);
        SimplePaperDoll.fill(context, x, y + height - 1, width, 1, color);
        SimplePaperDoll.fill(context, x, y, 1, height, color);
    }

    private static void fill(class_332 context, int x, int y, int width, int height, int color) {
        context.method_25294(x, y, x + width, y + height, color);
    }
}

