/*
 * Decompiled with CFR 0.152.
 */
package org.dreamtinker.dreamtinker;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.dreamtinker.dreamtinker.DreamtinkerModule;
import org.dreamtinker.dreamtinker.common.DreamtinkerCommon;
import org.dreamtinker.dreamtinker.common.DreamtinkerEffects;
import org.dreamtinker.dreamtinker.common.data.DreamtinkerRecipeProvider;
import org.dreamtinker.dreamtinker.common.data.loot.DreamtinkerLootTableProvider;
import org.dreamtinker.dreamtinker.common.data.tags.BlockTagProvider;
import org.dreamtinker.dreamtinker.common.data.tags.FluidTagProvider;
import org.dreamtinker.dreamtinker.common.data.tags.ItemTagProvider;
import org.dreamtinker.dreamtinker.common.event.advancements.star_regulus_boost;
import org.dreamtinker.dreamtinker.common.event.compact.enigmatic_legacy.addUnholyWater;
import org.dreamtinker.dreamtinker.common.event.compact.malum.addConcentratedGluttonyBottle;
import org.dreamtinker.dreamtinker.config.DreamtinkerConfig;
import org.dreamtinker.dreamtinker.fluids.DreamtinkerFluids;
import org.dreamtinker.dreamtinker.fluids.data.DreamtinkerFluidTextureProvider;
import org.dreamtinker.dreamtinker.library.event.PlayerLeftClickEvent;
import org.dreamtinker.dreamtinker.network.Dnetwork;
import org.dreamtinker.dreamtinker.tools.DreamtinkerModifiers;
import org.dreamtinker.dreamtinker.tools.DreamtinkerToolParts;
import org.dreamtinker.dreamtinker.tools.DreamtinkerTools;
import org.dreamtinker.dreamtinker.tools.modifiers.events.compact.enigmatic_legacy.death_handler;
import org.dreamtinker.dreamtinker.tools.modifiers.events.compact.malum.malum_events_handler;
import org.dreamtinker.dreamtinker.world.data.DTDataPackProvider;
import slimeknights.tconstruct.fluids.data.FluidBucketModelProvider;
import slimeknights.tconstruct.library.utils.Util;

@Mod(value="dreamtinker")
public class Dreamtinker {
    public static final String MODID = "dreamtinker";

    public Dreamtinker() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DreamtinkerConfig.specs, "DreamTinkerConfig.toml");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::commonSetup);
        modEventBus.register((Object)new DreamtinkerFluids());
        modEventBus.register((Object)new DreamtinkerEffects());
        modEventBus.register((Object)new DreamtinkerToolParts());
        modEventBus.register((Object)new DreamtinkerTools());
        modEventBus.register((Object)new DreamtinkerCommon());
        modEventBus.register((Object)new DreamtinkerModifiers());
        DreamtinkerModule.initRegisters(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (ModList.get().isLoaded("enigmaticlegacy")) {
            forgeEventBus.addGenericListener(ItemStack.class, addUnholyWater::attachCaps);
            forgeEventBus.addListener(death_handler::onLivingDeath);
        }
        if (ModList.get().isLoaded("malum")) {
            forgeEventBus.addGenericListener(ItemStack.class, addConcentratedGluttonyBottle::attachCaps);
            forgeEventBus.addListener(malum_events_handler::MalumLivingHurtEvent);
            forgeEventBus.addListener(malum_events_handler::MalumLivingDeathEvent);
        }
        forgeEventBus.addListener(PlayerLeftClickEvent::onLeftClickBlock);
        forgeEventBus.addListener(PlayerLeftClickEvent::onLeftClick);
        forgeEventBus.addListener(PlayerLeftClickEvent::onLeftClickEntity);
        forgeEventBus.addListener(star_regulus_boost::onServerTick);
        Dnetwork.registerPackets();
        modEventBus.addListener(this::gatherData);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.f_50276_).addPlant(DreamtinkerCommon.narcissus.getId(), DreamtinkerCommon.potted_narcissus));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public static ResourceLocation getLocation(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static String makeTranslationKey(String base, String name) {
        return Util.makeTranslationKey((String)base, (ResourceLocation)Dreamtinker.getLocation(name));
    }

    public static MutableComponent makeTranslation(String base, String name) {
        return Component.m_237115_((String)Dreamtinker.makeTranslationKey(base, name));
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new DreamtinkerFluidTextureProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new FluidBucketModelProvider(output, MODID));
        generator.addProvider(event.includeClient(), (DataProvider)new FluidTagProvider(output, lookupProvider, MODID, helper));
        BlockTagProvider blockTags = new BlockTagProvider(output, lookupProvider, MODID, helper);
        generator.addProvider(event.includeClient(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(output, lookupProvider, blockTags.m_274426_(), MODID, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new DreamtinkerRecipeProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new DreamtinkerLootTableProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new DTDataPackProvider(output, lookupProvider));
    }
}

